/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.cascading2.scheme;

import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.tap.Tap;
import com.google.protobuf.Message;
import com.twitter.elephantbird.cascading2.scheme.LzoBinaryScheme;
import com.twitter.elephantbird.mapred.input.DeprecatedInputFormatWrapper;
import com.twitter.elephantbird.mapred.output.DeprecatedOutputFormatWrapper;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.mapreduce.output.LzoProtobufBlockOutputFormat;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;

public class LzoProtobufScheme<M extends Message>
extends LzoBinaryScheme<M, ProtobufWritable<M>> {
    private static final long serialVersionUID = -5011096855302946105L;
    private Class protoClass;

    public LzoProtobufScheme(Class clazz) {
        this.protoClass = clazz;
    }

    @Override
    protected ProtobufWritable<M> prepareBinaryWritable() {
        TypeRef typeRef = Protobufs.getTypeRef(this.protoClass.getName());
        return new ProtobufWritable(typeRef);
    }

    public void sinkConfInit(HadoopFlowProcess hadoopFlowProcess, Tap tap, JobConf jobConf) {
        LzoProtobufBlockOutputFormat.setClassConf(this.protoClass, (Configuration)jobConf);
        DeprecatedOutputFormatWrapper.setOutputFormat(LzoProtobufBlockOutputFormat.class, jobConf);
    }

    public void sourceConfInit(HadoopFlowProcess hadoopFlowProcess, Tap tap, JobConf jobConf) {
        MultiInputFormat.setClassConf(this.protoClass, (Configuration)jobConf);
        DeprecatedInputFormatWrapper.setInputFormat(MultiInputFormat.class, jobConf);
    }
}

