/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class W3CLogParser {
    protected static final Logger LOG = LoggerFactory.getLogger(W3CLogParser.class);
    private Map<String, List<String>> fieldDef_ = Maps.newHashMap();
    private static final String DELIMITER = "\\s+";

    public W3CLogParser(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            List<String> list = Arrays.asList(string.split(DELIMITER));
            this.fieldDef_.put(list.get(0), list.subList(1, list.size()));
        }
    }

    public Map<String, String> parse(String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<String> list = Arrays.asList(string.split(DELIMITER));
        List<String> list2 = this.fieldDef_.get(list.get(0));
        if (list2 == null) {
            throw new IOException("cannot find matching field definition for CRC " + list.get(0));
        }
        if (list2.size() != list.size()) {
            throw new IOException("W3C field definition and input line for CRC " + list.get(0) + " does not match:\n" + string);
        }
        for (int i = 1; i < list2.size(); ++i) {
            hashMap.put(list2.get(i), list.get(i));
        }
        return hashMap;
    }
}

