/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TBase;

public class ThriftUtils {
    private static final String CLASS_CONF_PREFIX = "elephantbird.thrift.class.for.";

    public static void setClassConf(Configuration configuration, Class<?> clazz, Class<? extends TBase<?, ?>> clazz2) {
        String string = CLASS_CONF_PREFIX + clazz.getName();
        HadoopUtils.setInputFormatClass(configuration, string, clazz2);
    }

    private static void verifyAncestry(Class<?> clazz) {
        if (!TBase.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz.getName() + " is not a Thrift class");
        }
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(Configuration configuration, Class<?> clazz) {
        String string = configuration.get(CLASS_CONF_PREFIX + clazz.getName());
        if (string == null) {
            throw new RuntimeException(CLASS_CONF_PREFIX + clazz.getName() + " is not set");
        }
        Class clazz2 = null;
        try {
            clazz2 = configuration.getClassByName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        ThriftUtils.verifyAncestry(clazz2);
        return new TypeRef<M>(clazz2){};
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(Class<?> clazz) {
        ThriftUtils.verifyAncestry(clazz);
        return new TypeRef<M>(clazz){};
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string) : Class.forName(string, true, classLoader);
            ThriftUtils.verifyAncestry(clazz);
            return new TypeRef<M>(clazz){};
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(String string) {
        return ThriftUtils.getTypeRef(string, null);
    }

    public static <M> M getFieldValue(Object object, String string, Class<M> clazz) {
        return ThriftUtils.getFieldValue(object.getClass(), object, string, clazz);
    }

    public static <M> M getFieldValue(Class<?> clazz, String string, Class<M> clazz2) {
        return ThriftUtils.getFieldValue(clazz, null, string, clazz2);
    }

    private static <M> M getFieldValue(Class<?> clazz, Object object, String string, Class<M> clazz2) {
        try {
            Field field = clazz.getDeclaredField(string);
            return clazz2.cast(field.get(object));
        }
        catch (Exception exception) {
            throw new RuntimeException("while trying to find " + string + " in " + clazz.getName(), exception);
        }
    }

    public static Class<?> getFiedlType(Class<?> clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            return field.getType();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("while trying to find " + string + " in " + clazz, noSuchFieldException);
        }
    }
}

