/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class ThriftToDynamicProto<T extends TBase<?, ?>> {
    private static final Logger LOG = LogManager.getLogger(ThriftToDynamicProto.class);
    DynamicMessage.Builder protoBuilder;
    Descriptors.Descriptor msgDescriptor;
    Message protoObj;

    public ThriftToDynamicProto(Class<T> clazz) throws Descriptors.DescriptorValidationException {
        this(clazz, new ArrayList<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>>());
    }

    public ThriftToDynamicProto(Class<T> clazz, List<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>> list) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto.Builder builder = DescriptorProtos.DescriptorProto.newBuilder();
        builder.setName("dynaMessage");
        TStructDescriptor tStructDescriptor = TStructDescriptor.getInstance(clazz);
        int n = 0;
        for (TStructDescriptor.Field object22 : tStructDescriptor.getFields()) {
            DescriptorProtos.FieldDescriptorProto.Type type = this.thriftTypeToProtoType(object22);
            n = Math.max(object22.getFieldId(), n);
            this.addField(builder, object22.getName(), object22.getFieldId() + 1, type);
        }
        int n2 = n + 1;
        for (Pair<String, DescriptorProtos.FieldDescriptorProto.Type> pair : list) {
            this.addField(builder, pair.getFirst(), ++n2, pair.getSecond());
        }
        DescriptorProtos.DescriptorProto descriptorProto = builder.build();
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor[] fileDescriptorArray = new Descriptors.FileDescriptor[]{};
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])fileDescriptorArray);
        this.msgDescriptor = fileDescriptor.findMessageTypeByName("dynaMessage");
        this.protoBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.msgDescriptor);
    }

    private void addField(DescriptorProtos.DescriptorProto.Builder builder, String string, int n, DescriptorProtos.FieldDescriptorProto.Type type) {
        DescriptorProtos.FieldDescriptorProto.Builder builder2 = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(string).setNumber(n).setType(type);
        builder.addField(builder2.build());
    }

    public DynamicMessage convert(T t) {
        DynamicMessage.Builder builder = this.protoBuilder.clone();
        TStructDescriptor tStructDescriptor = TStructDescriptor.getInstance(t.getClass());
        int n = 0;
        for (TStructDescriptor.Field field : tStructDescriptor.getFields()) {
            Object object;
            Descriptors.FieldDescriptor fieldDescriptor = this.msgDescriptor.findFieldByName(field.getName());
            if (fieldDescriptor == null) {
                throw new RuntimeException("Field " + field.getName() + " not found in dynamic protobuf.");
            }
            if ((object = tStructDescriptor.getFieldValue(n++, (TBase)t)) == null) continue;
            if (field.isEnum()) {
                object = object.toString();
            } else if (field.isBuffer()) {
                object = ByteString.copyFrom((byte[])((byte[])object));
            }
            builder.setField(fieldDescriptor, object);
        }
        return builder.build();
    }

    private DescriptorProtos.FieldDescriptorProto.Type thriftTypeToProtoType(TStructDescriptor.Field field) {
        byte by = field.getType();
        switch (by) {
            case 2: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
            }
            case 3: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 4: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
            }
            case 6: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 8: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 10: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
            }
            case 11: {
                return field.isBuffer() ? DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES : DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            }
            case 16: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            }
        }
        throw new IllegalArgumentException("Can't map Thrift type " + by + " to a ProtoBuf type");
    }
}

