/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.hadoop.compression.lzo.LzopCodec;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LzoUtils {
    public static final Logger LOG = LogManager.getLogger(LzoUtils.class);
    private static boolean isLzopIndexSupported = false;

    public static DataOutputStream getIndexedLzoOutputStream(Configuration configuration, Path path) throws IOException {
        LzopCodec lzopCodec = new LzopCodec();
        lzopCodec.setConf(configuration);
        final Path path2 = path;
        final FileSystem fileSystem = path2.getFileSystem(configuration);
        FSDataOutputStream fSDataOutputStream = fileSystem.create(path2, false);
        FSDataOutputStream fSDataOutputStream2 = null;
        if (configuration.getBoolean("elephantbird.lzo.output.index", false)) {
            if (isLzopIndexSupported) {
                Path path3 = path2.suffix(".index.tmp");
                fSDataOutputStream2 = fileSystem.create(path3, false);
            } else {
                LOG.warn((Object)"elephantbird.lzo.output.index is enabled, but LzopCodec does not have createIndexedOutputStream method. Please upgrade hadoop-lzo.");
            }
        }
        final boolean bl = fSDataOutputStream2 != null;
        CompressionOutputStream compressionOutputStream = bl ? lzopCodec.createIndexedOutputStream((OutputStream)fSDataOutputStream, fSDataOutputStream2) : lzopCodec.createOutputStream((OutputStream)fSDataOutputStream);
        return new DataOutputStream((OutputStream)compressionOutputStream){

            @Override
            public void close() throws IOException {
                super.close();
                if (bl) {
                    Path path = path2.suffix(".index.tmp");
                    FileStatus fileStatus = fileSystem.getFileStatus(path2);
                    if (fileStatus.getLen() <= fileStatus.getBlockSize()) {
                        fileSystem.delete(path, false);
                    } else {
                        fileSystem.rename(path, path2.suffix(".index"));
                    }
                }
            }
        };
    }

    static {
        try {
            isLzopIndexSupported = null != LzopCodec.class.getMethod("createIndexedOutputStream", OutputStream.class, DataOutputStream.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

