/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);

    public static Counter getCounter(JobContext jobContext, String string, String string2) {
        if (jobContext instanceof TaskInputOutputContext) {
            return ((TaskInputOutputContext)jobContext).getCounter(string, string2);
        }
        String string3 = string + ":" + string2;
        LOG.warn("Context is not a TaskInputOutputContext. will return a dummy counter for '" + string3 + "'");
        return new Counter(string3, string3){};
    }

    public static void setInputFormatClass(Configuration configuration, String string, Class<?> clazz) {
        String string2 = configuration.get(string);
        String string3 = clazz.getName();
        if (string2 != null && !string2.equals(string3)) {
            throw new RuntimeException("Already registered a different thriftClass for " + string + ". old: " + string2 + " new: " + string3);
        }
        configuration.set(string, string3);
    }
}

