/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.twitter.elephantbird.util.ThriftUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;

public class TStructDescriptor {
    private static Map<Class<?>, TStructDescriptor> structMap = Maps.newHashMap();
    private List<Field> fields;
    private Class<? extends TBase<?, ?>> tClass;

    public Class<? extends TBase<?, ?>> getThriftClass() {
        return this.tClass;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Field getFieldAt(int n) {
        return this.fields.get(n);
    }

    public Object getFieldValue(int n, TBase tBase) {
        Field field = this.fields.get(n);
        try {
            return tBase.getFieldValue(field.getFieldIdEnum());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TStructDescriptor getInstance(Class<? extends TBase<?, ?>> clazz) {
        Map<Class<?>, TStructDescriptor> map = structMap;
        synchronized (map) {
            TStructDescriptor tStructDescriptor = structMap.get(clazz);
            if (tStructDescriptor == null) {
                tStructDescriptor = new TStructDescriptor();
                tStructDescriptor.tClass = clazz;
                structMap.put(clazz, tStructDescriptor);
                tStructDescriptor.build(clazz);
            }
            return tStructDescriptor;
        }
    }

    private TStructDescriptor() {
    }

    private void build(Class<? extends TBase<?, ?>> clazz) {
        Map map = FieldMetaData.getStructMetaDataMap(clazz);
        Object[] objectArray = new Field[map.size()];
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            objectArray[n++] = new Field((TFieldIdEnum)entry.getKey(), ((TFieldIdEnum)entry.getKey()).getFieldName(), clazz, ((FieldMetaData)entry.getValue()).valueMetaData);
        }
        this.fields = ImmutableList.copyOf((Object[])objectArray);
    }

    private static Map<String, TEnum> extractEnumMap(Class<? extends TEnum> clazz) {
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)clazz.getEnumConstants().length);
        for (TEnum tEnum : clazz.getEnumConstants()) {
            hashMap.put(tEnum.toString(), tEnum);
        }
        return hashMap;
    }

    public static class Field {
        private final TFieldIdEnum fieldIdEnum;
        private final short fieldId;
        private final String fieldName;
        private final FieldValueMetaData field;
        private final Field listElemField;
        private final Field setElemField;
        private final Field mapKeyField;
        private final Field mapValueField;
        private final Map<String, TEnum> enumMap;
        private final TStructDescriptor tStructDescriptor;
        private final boolean isBuffer_;

        private Field(TFieldIdEnum tFieldIdEnum, String string, Class<?> clazz, FieldValueMetaData fieldValueMetaData) {
            this.fieldIdEnum = tFieldIdEnum;
            this.fieldId = tFieldIdEnum == null ? (short)1 : tFieldIdEnum.getThriftFieldId();
            this.fieldName = string;
            this.field = fieldValueMetaData;
            boolean bl = fieldValueMetaData.getClass() == FieldValueMetaData.class;
            this.listElemField = !bl && fieldValueMetaData instanceof ListMetaData ? new Field(null, string + "_list_elem", null, ((ListMetaData)fieldValueMetaData).elemMetaData) : null;
            if (!bl && fieldValueMetaData instanceof MapMetaData) {
                this.mapKeyField = new Field(null, string + "_map_key", null, ((MapMetaData)fieldValueMetaData).keyMetaData);
                this.mapValueField = new Field(null, string + "_map_value", null, ((MapMetaData)fieldValueMetaData).valueMetaData);
            } else {
                this.mapKeyField = null;
                this.mapValueField = null;
            }
            this.setElemField = !bl && fieldValueMetaData instanceof SetMetaData ? new Field(null, string + "_set_elem", null, ((SetMetaData)fieldValueMetaData).elemMetaData) : null;
            this.enumMap = !bl && fieldValueMetaData instanceof EnumMetaData ? TStructDescriptor.extractEnumMap(((EnumMetaData)fieldValueMetaData).enumClass) : null;
            this.tStructDescriptor = fieldValueMetaData.isStruct() ? TStructDescriptor.getInstance(((StructMetaData)fieldValueMetaData).structClass) : null;
            this.isBuffer_ = fieldValueMetaData.type == 11 && clazz != null ? ByteBuffer.class == ThriftUtils.getFiedlType(clazz, string) : false;
        }

        public short getFieldId() {
            return this.fieldId;
        }

        public byte getType() {
            return this.field.type;
        }

        public TFieldIdEnum getFieldIdEnum() {
            return this.fieldIdEnum;
        }

        public FieldValueMetaData getField() {
            return this.field;
        }

        public boolean isBuffer() {
            return this.isBuffer_;
        }

        public boolean isList() {
            return this.listElemField != null;
        }

        public Field getListElemField() {
            return this.listElemField;
        }

        public boolean isSet() {
            return this.setElemField != null;
        }

        public Field getSetElemField() {
            return this.setElemField;
        }

        public boolean isMap() {
            return this.mapKeyField != null;
        }

        public Field getMapKeyField() {
            return this.mapKeyField;
        }

        public Field getMapValueField() {
            return this.mapValueField;
        }

        public boolean isStruct() {
            return this.tStructDescriptor != null;
        }

        public TStructDescriptor gettStructDescriptor() {
            return this.tStructDescriptor;
        }

        public boolean isEnum() {
            return this.enumMap != null;
        }

        public TEnum getEnumValueOf(String string) {
            return this.enumMap.get(string);
        }

        public String getName() {
            return this.fieldName;
        }

        public short getId() {
            return this.fieldId;
        }
    }
}

