/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import com.twitter.elephantbird.pig.util.PigToProtobuf;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.pig.util.ProtobufToPig;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class ProtobufWritableConverter<M extends Message>
extends AbstractWritableConverter<ProtobufWritable<M>> {
    protected final TypeRef<M> typeRef;
    protected final ProtobufToPig protobufToPig;

    public ProtobufWritableConverter(String string) {
        super(new ProtobufWritable());
        Preconditions.checkNotNull((Object)string);
        this.typeRef = PigUtil.getProtobufTypeRef(string);
        this.protobufToPig = new ProtobufToPig();
        ((ProtobufWritable)this.writable).setConverter(this.typeRef.getRawClass());
    }

    @Override
    public void initialize(Class<? extends ProtobufWritable<M>> clazz) throws IOException {
        if (clazz == null) {
            return;
        }
        super.initialize(clazz);
        ((ProtobufWritable)this.writable).setConverter(this.typeRef.getRawClass());
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        return new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(null, this.protobufToPig.toSchema(Protobufs.getMessageDescriptor(this.typeRef.getRawClass()))));
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return this.bytesToTuple(dataByteArray.get(), null);
    }

    @Override
    protected Tuple toTuple(ProtobufWritable<M> protobufWritable, ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        return this.protobufToPig.toTuple((Message)protobufWritable.get());
    }

    @Override
    protected ProtobufWritable<M> toWritable(Tuple tuple) throws IOException {
        ((ProtobufWritable)this.writable).set(PigToProtobuf.tupleToMessage(this.typeRef.getRawClass(), tuple));
        return (ProtobufWritable)this.writable;
    }
}

