/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.data.proto.Misc;
import com.twitter.elephantbird.pig.util.ProtobufTuple;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufToPig {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufToPig.class);
    private static final TupleFactory tupleFactory_ = TupleFactory.getInstance();
    private static BagFactory bagFactory_ = BagFactory.getInstance();
    private final CoercionLevel coercionLevel_;

    public ProtobufToPig() {
        this(CoercionLevel.kAllowCoercionToPigMaps);
    }

    public ProtobufToPig(CoercionLevel coercionLevel) {
        this.coercionLevel_ = coercionLevel;
    }

    public Tuple toTuple(Message message) {
        if (message == null) {
            return null;
        }
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        Tuple tuple = tupleFactory_.newTuple(descriptor.getFields().size());
        int n = 0;
        try {
            for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                Object object = this.getFieldValue(message, fieldDescriptor);
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    tuple.set(n++, this.messageToTuple(fieldDescriptor, object));
                    continue;
                }
                tuple.set(n++, this.singleFieldToTuple(fieldDescriptor, object));
            }
        }
        catch (ExecException execException) {
            LOG.warn("Could not convert msg " + message + " to tuple", (Throwable)execException);
        }
        return tuple;
    }

    protected Object fieldToPig(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            return this.messageToTuple(fieldDescriptor, object);
        }
        return this.singleFieldToTuple(fieldDescriptor, object);
    }

    protected Object messageToTuple(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        assert (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) : "messageToTuple called with field of type " + fieldDescriptor.getType();
        if (fieldDescriptor.isRepeated()) {
            List list = (List)(object != null ? object : Lists.newArrayList());
            if (this.coercionLevel_ == CoercionLevel.kAllowCoercionToPigMaps && fieldDescriptor.getMessageType().getName().equals(Misc.CountedMap.getDescriptor().getName())) {
                HashMap hashMap = Maps.newHashMap();
                for (Message message : list) {
                    Misc.CountedMap countedMap = (Misc.CountedMap)message;
                    Long l = (Long)hashMap.get(countedMap.getKey());
                    hashMap.put(countedMap.getKey(), (l == null ? 0L : l) + countedMap.getValue());
                }
                return hashMap;
            }
            DataBag dataBag = bagFactory_.newDefaultBag();
            for (Message message : list) {
                dataBag.add((Tuple)new ProtobufTuple(message));
            }
            return dataBag;
        }
        return new ProtobufTuple((Message)object);
    }

    protected Object singleFieldToTuple(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        assert (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) : "messageToFieldSchema called with field of type " + fieldDescriptor.getType();
        if (fieldDescriptor.isRepeated()) {
            DataBag dataBag = bagFactory_.newDefaultBag();
            List list = (List)(object != null ? object : Lists.newArrayList());
            for (Object e : list) {
                Object object2 = this.coerceToPigTypes(fieldDescriptor, e);
                Tuple tuple = tupleFactory_.newTuple(1);
                try {
                    tuple.set(0, object2);
                }
                catch (ExecException execException) {
                    throw new RuntimeException(execException);
                }
                dataBag.add(tuple);
            }
            return dataBag;
        }
        return this.coerceToPigTypes(fieldDescriptor, object);
    }

    private Object coerceToPigTypes(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM && object != null) {
            Descriptors.EnumValueDescriptor enumValueDescriptor = (Descriptors.EnumValueDescriptor)object;
            return enumValueDescriptor.getName();
        }
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.BOOL && object != null) {
            Boolean bl = (Boolean)object;
            return new Integer(bl != false ? 1 : 0);
        }
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.BYTES && object != null) {
            ByteString byteString = (ByteString)object;
            return new DataByteArray(byteString.toByteArray());
        }
        return object;
    }

    protected Object getFieldValue(Message message, Descriptors.FieldDescriptor fieldDescriptor) {
        Object object = null;
        Map map = message.getAllFields();
        if (map.containsKey(fieldDescriptor)) {
            object = map.get(fieldDescriptor);
        } else if (fieldDescriptor.hasDefaultValue()) {
            object = fieldDescriptor.getDefaultValue();
        }
        return object;
    }

    public Schema toSchema(Descriptors.Descriptor descriptor) {
        Schema schema = new Schema();
        try {
            for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    schema.add(this.messageToFieldSchema(fieldDescriptor));
                    continue;
                }
                schema.add(this.singleFieldToFieldSchema(fieldDescriptor));
            }
        }
        catch (FrontendException frontendException) {
            LOG.warn("Could not convert descriptor " + descriptor + " to schema", (Throwable)frontendException);
        }
        return schema;
    }

    private Schema.FieldSchema messageToFieldSchema(Descriptors.FieldDescriptor fieldDescriptor) throws FrontendException {
        assert (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) : "messageToFieldSchema called with field of type " + fieldDescriptor.getType();
        if (this.coercionLevel_ == CoercionLevel.kAllowCoercionToPigMaps && fieldDescriptor.getMessageType().getName().equals(Misc.CountedMap.getDescriptor().getName()) && fieldDescriptor.isRepeated()) {
            return new Schema.FieldSchema(fieldDescriptor.getName(), null, 100);
        }
        Schema schema = this.toSchema(fieldDescriptor.getMessageType());
        if (fieldDescriptor.isRepeated()) {
            Schema schema2 = new Schema();
            schema2.add(new Schema.FieldSchema(fieldDescriptor.getName() + "_tuple", schema, 110));
            return new Schema.FieldSchema(fieldDescriptor.getName(), schema2, 120);
        }
        return new Schema.FieldSchema(fieldDescriptor.getName(), schema, 110);
    }

    private Schema.FieldSchema singleFieldToFieldSchema(Descriptors.FieldDescriptor fieldDescriptor) throws FrontendException {
        assert (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) : "singleFieldToFieldSchema called with field of type " + fieldDescriptor.getType();
        if (fieldDescriptor.isRepeated()) {
            Schema schema = new Schema();
            schema.add(new Schema.FieldSchema(fieldDescriptor.getName(), null, this.getPigDataType(fieldDescriptor)));
            Schema schema2 = new Schema();
            schema2.add(new Schema.FieldSchema(fieldDescriptor.getName() + "_tuple", schema, 110));
            return new Schema.FieldSchema(fieldDescriptor.getName() + "_bag", schema2, 120);
        }
        return new Schema.FieldSchema(fieldDescriptor.getName(), null, this.getPigDataType(fieldDescriptor));
    }

    private byte getPigDataType(Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getType()) {
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: 
            case BOOL: {
                return 10;
            }
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return 15;
            }
            case FLOAT: {
                return 20;
            }
            case DOUBLE: {
                return 25;
            }
            case STRING: 
            case ENUM: {
                return 55;
            }
            case BYTES: {
                return 50;
            }
            case MESSAGE: {
                throw new IllegalArgumentException("getPigDataType called on field " + fieldDescriptor.getFullName() + " of type message.");
            }
        }
        throw new IllegalArgumentException("Unexpected field type. " + fieldDescriptor.toString() + " " + fieldDescriptor.getFullName() + " " + fieldDescriptor.getType());
    }

    public String toPigScript(Descriptors.Descriptor descriptor, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("raw_data = load '$INPUT_FILES' using " + string + "()").append("\n");
        stringBuffer.append(this.tabs(3)).append("as (").append("\n");
        stringBuffer.append(this.toPigScriptInternal(descriptor, 3));
        stringBuffer.append(this.tabs(3)).append(");").append("\n").append("\n");
        return stringBuffer.toString();
    }

    public String toPigScript(Descriptors.Descriptor descriptor, String string, String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("raw_data = load '$INPUT_FILES' using ").append(string).append("(");
        String string2 = "";
        if (stringArray.length > 0) {
            string2 = "'" + Joiner.on((String)",'").join((Object[])stringArray) + "'";
        }
        stringBuffer.append(string2).append(")").append("\n");
        stringBuffer.append("/**\n");
        stringBuffer.append(this.tabs(3)).append("as (").append("\n");
        stringBuffer.append(this.toPigScriptInternal(descriptor, 3));
        stringBuffer.append(this.tabs(3)).append(")").append("\n").append("\n");
        stringBuffer.append("**/\n;\n");
        return stringBuffer.toString();
    }

    private StringBuffer toPigScriptInternal(Descriptors.Descriptor descriptor, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                boolean bl;
                boolean bl2 = bl = fieldDescriptor == descriptor.getFields().get(descriptor.getFields().size() - 1);
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    stringBuffer.append(this.messageToPigScript(fieldDescriptor, n + 1, bl));
                    continue;
                }
                stringBuffer.append(this.singleFieldToPigScript(fieldDescriptor, n + 1, bl));
            }
        }
        catch (FrontendException frontendException) {
            LOG.warn("Could not convert descriptor " + descriptor + " to pig script", (Throwable)frontendException);
        }
        return stringBuffer;
    }

    private StringBuffer messageToPigScript(Descriptors.FieldDescriptor fieldDescriptor, int n, boolean bl) throws FrontendException {
        assert (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) : "messageToPigScript called with field of type " + fieldDescriptor.getType();
        if (this.coercionLevel_ == CoercionLevel.kAllowCoercionToPigMaps && fieldDescriptor.getMessageType().getName().equals(Misc.CountedMap.getDescriptor().getName()) && fieldDescriptor.isRepeated()) {
            return new StringBuffer().append(this.tabs(n)).append(fieldDescriptor.getName()).append(": map[]").append(bl ? "" : ",").append("\n");
        }
        if (fieldDescriptor.isRepeated()) {
            return new StringBuffer().append(this.tabs(n)).append(fieldDescriptor.getName()).append(": bag {").append("\n").append(this.tabs(n + 1)).append(fieldDescriptor.getName()).append("_tuple: tuple (").append("\n").append(this.toPigScriptInternal(fieldDescriptor.getMessageType(), n + 2)).append(this.tabs(n + 1)).append(")").append("\n").append(this.tabs(n)).append("}").append(bl ? "" : ",").append("\n");
        }
        return new StringBuffer().append(this.tabs(n)).append(fieldDescriptor.getName()).append(": tuple (").append("\n").append(this.toPigScriptInternal(fieldDescriptor.getMessageType(), n + 1)).append(this.tabs(n)).append(")").append(bl ? "" : ",").append("\n");
    }

    private StringBuffer singleFieldToPigScript(Descriptors.FieldDescriptor fieldDescriptor, int n, boolean bl) throws FrontendException {
        assert (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) : "singleFieldToPigScript called with field of type " + fieldDescriptor.getType();
        if (fieldDescriptor.isRepeated()) {
            return new StringBuffer().append(this.tabs(n)).append(fieldDescriptor.getName()).append("_bag: bag {").append("\n").append(this.tabs(n + 1)).append(fieldDescriptor.getName()).append("_tuple: tuple (").append("\n").append(this.tabs(n + 2)).append(fieldDescriptor.getName()).append(": ").append(this.getPigScriptDataType(fieldDescriptor)).append("\n").append(this.tabs(n + 1)).append(")").append("\n").append(this.tabs(n)).append("}").append(bl ? "" : ",").append("\n");
        }
        return new StringBuffer().append(this.tabs(n)).append(fieldDescriptor.getName()).append(": ").append(this.getPigScriptDataType(fieldDescriptor)).append(bl ? "" : ",").append("\n");
    }

    private String getPigScriptDataType(Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getType()) {
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: 
            case BOOL: {
                return "int";
            }
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case STRING: 
            case ENUM: {
                return "chararray";
            }
            case BYTES: {
                return "bytearray";
            }
            case MESSAGE: {
                throw new IllegalArgumentException("getPigScriptDataType called on field " + fieldDescriptor.getFullName() + " of type message.");
            }
        }
        throw new IllegalArgumentException("Unexpected field type. " + fieldDescriptor.toString() + " " + fieldDescriptor.getFullName() + " " + fieldDescriptor.getType());
    }

    private StringBuffer tabs(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        return stringBuffer;
    }

    public static enum CoercionLevel {
        kNoCoercion,
        kAllowCoercionToPigMaps;

    }
}

