/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.TypeRef;
import java.util.List;
import org.apache.pig.LoadPushDown;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.thrift.TBase;

public class ProjectedThriftTupleFactory<T extends TBase<?, ?>> {
    private static TupleFactory tf = TupleFactory.getInstance();
    private int[] requiredFields;
    private final TStructDescriptor tStructDesc;

    public ProjectedThriftTupleFactory(TypeRef<T> typeRef, LoadPushDown.RequiredFieldList requiredFieldList) {
        this.tStructDesc = TStructDescriptor.getInstance(typeRef.getRawClass());
        int n = this.tStructDesc.getFields().size();
        if (requiredFieldList != null) {
            List list = requiredFieldList.getFields();
            this.requiredFields = new int[list.size()];
            int n2 = 0;
            for (LoadPushDown.RequiredField requiredField : list) {
                Preconditions.checkState((requiredField.getIndex() < n ? 1 : 0) != 0, (Object)"Projected index is out of range");
                this.requiredFields[n2++] = requiredField.getIndex();
            }
        } else {
            this.requiredFields = new int[n];
            for (int i = 0; i < n; ++i) {
                this.requiredFields[i] = i;
            }
        }
    }

    public Tuple newTuple(T t) throws ExecException {
        int n = this.requiredFields.length;
        List<TStructDescriptor.Field> list = this.tStructDesc.getFields();
        Tuple tuple = tf.newTuple(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.requiredFields[i];
            Object object = this.tStructDesc.getFieldValue(n2, (TBase)t);
            tuple.set(i, ThriftToPig.toPigObject(list.get(n2), object, true));
        }
        return tuple;
    }
}

