/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.TypeRef;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;

public class PigToThrift<T extends TBase<?, ?>> {
    private TStructDescriptor structDesc;

    public static <T extends TBase<?, ?>> PigToThrift<T> newInstance(Class<T> clazz) {
        return new PigToThrift<T>(clazz);
    }

    public static <T extends TBase<?, ?>> PigToThrift<T> newInstance(TypeRef<T> typeRef) {
        return new PigToThrift<T>(typeRef.getRawClass());
    }

    public PigToThrift(Class<T> clazz) {
        this.structDesc = TStructDescriptor.getInstance(clazz);
    }

    public T getThriftObject(Tuple tuple) {
        return (T)PigToThrift.toThrift(this.structDesc, tuple);
    }

    private static TBase<?, ?> toThrift(TStructDescriptor tStructDescriptor, Tuple tuple) {
        int n = tStructDescriptor.getFields().size();
        int n2 = tuple.size();
        TBase<? extends TBase<?, ?>, ? extends TBase<?, ?>> tBase = PigToThrift.newTInstance(tStructDescriptor.getThriftClass());
        for (int i = 0; i < n && i < n2; ++i) {
            Object object;
            try {
                object = tuple.get(i);
            }
            catch (ExecException execException) {
                throw new RuntimeException(execException);
            }
            if (object == null) continue;
            TStructDescriptor.Field field = tStructDescriptor.getFieldAt(i);
            try {
                tBase.setFieldValue(field.getFieldIdEnum(), PigToThrift.toThriftValue(field, object));
                continue;
            }
            catch (Exception exception) {
                String string = String.valueOf(tBase);
                if (100 < string.length()) {
                    string = string.substring(0, 97) + "...";
                }
                String string2 = tBase == null ? "unknown" : tBase.getClass().getName();
                throw new RuntimeException(String.format("Failed to set field '%s' using tuple value '%s' of type '%s' at index %d", field.getName(), string, string2, i), exception);
            }
        }
        return tBase;
    }

    private static Object toThriftValue(TStructDescriptor.Field field, Object object) {
        try {
            switch (field.getType()) {
                case 2: {
                    return (Integer)object != 0;
                }
                case 3: {
                    return ((Integer)object).byteValue();
                }
                case 6: {
                    return ((Integer)object).shortValue();
                }
                case 11: {
                    return PigToThrift.toStringType(object);
                }
                case 12: {
                    return PigToThrift.toThrift(field.gettStructDescriptor(), (Tuple)object);
                }
                case 13: {
                    return PigToThrift.toThriftMap(field, (Map)object);
                }
                case 14: {
                    return PigToThrift.toThriftSet(field.getSetElemField(), (DataBag)object);
                }
                case 15: {
                    return PigToThrift.toThriftList(field.getListElemField(), (DataBag)object);
                }
                case 16: {
                    return field.getEnumValueOf(object.toString());
                }
            }
            return object;
        }
        catch (Exception exception) {
            ThriftToPig.LOG.warn((Object)("Exception while convering Tuple to Thrift.  from " + object.getClass() + " to " + field.getName() + (field.getFieldIdEnum() == null ? "" : "(field id : " + field.getFieldIdEnum().getClass() + ")")), (Throwable)exception);
            return null;
        }
    }

    private static Object toStringType(Object object) {
        if (object instanceof String) {
            return object;
        }
        if (object instanceof DataByteArray) {
            byte[] byArray = ((DataByteArray)object).get();
            return ByteBuffer.wrap(Arrays.copyOf(byArray, byArray.length));
        }
        return null;
    }

    private static Map<Object, Object> toThriftMap(TStructDescriptor.Field field, Map<String, Object> map) {
        TStructDescriptor.Field field2 = field.getMapKeyField();
        TStructDescriptor.Field field3 = field.getMapValueField();
        if (field2.getType() != 11 && field2.getType() != 16) {
            throw new IllegalArgumentException("TStructs's map key should be a STRING or an ENUM");
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            hashMap.put(PigToThrift.toThriftValue(field2, entry.getKey()), PigToThrift.toThriftValue(field3, entry.getValue()));
        }
        return hashMap;
    }

    private static Set<Object> toThriftSet(TStructDescriptor.Field field, DataBag dataBag) {
        HashSet<Object> hashSet = new HashSet<Object>((int)dataBag.size());
        PigToThrift.fillThriftCollection(hashSet, field, dataBag);
        return hashSet;
    }

    private static List<Object> toThriftList(TStructDescriptor.Field field, DataBag dataBag) {
        ArrayList<Object> arrayList = new ArrayList<Object>((int)dataBag.size());
        PigToThrift.fillThriftCollection(arrayList, field, dataBag);
        return arrayList;
    }

    private static void fillThriftCollection(Collection<Object> collection, TStructDescriptor.Field field, DataBag dataBag) {
        for (Tuple tuple : dataBag) {
            if (!field.isStruct()) {
                try {
                    collection.add(PigToThrift.toThriftValue(field, tuple.get(0)));
                    continue;
                }
                catch (ExecException execException) {
                    throw new RuntimeException(execException);
                }
            }
            collection.add(PigToThrift.toThriftValue(field, tuple));
        }
    }

    private static TBase<?, ?> newTInstance(Class<?> clazz) {
        try {
            return (TBase)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

