/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PigToProtobuf {
    private static final Logger LOG = LoggerFactory.getLogger(PigToProtobuf.class);

    public static <M extends Message> M tupleToMessage(Class<M> clazz, Tuple tuple) {
        Message.Builder builder = Protobufs.getMessageBuilder(clazz);
        return (M)PigToProtobuf.tupleToMessage(builder, tuple);
    }

    public static Message tupleToMessage(Message.Builder builder, Tuple tuple) {
        List list = builder.getDescriptorForType().getFields();
        if (tuple == null) {
            return builder.build();
        }
        for (int i = 0; i < list.size() && i < tuple.size(); ++i) {
            Object object = null;
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)list.get(i);
            try {
                object = tuple.get(i);
            }
            catch (ExecException execException) {
                LOG.warn("Could not convert tuple field " + object + " to field with descriptor " + fieldDescriptor);
                continue;
            }
            if (object == null) continue;
            try {
                if (fieldDescriptor.isRepeated()) {
                    builder.setField(fieldDescriptor, PigToProtobuf.dataBagToRepeatedField(builder, fieldDescriptor, (DataBag)object));
                    continue;
                }
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    Message.Builder builder2 = builder.newBuilderForField(fieldDescriptor);
                    builder.setField(fieldDescriptor, (Object)PigToProtobuf.tupleToMessage(builder2, (Tuple)object));
                    continue;
                }
                builder.setField(fieldDescriptor, PigToProtobuf.tupleFieldToSingleField(fieldDescriptor, object));
                continue;
            }
            catch (Exception exception) {
                String string = String.valueOf(object);
                if (100 < string.length()) {
                    string = string.substring(0, 97) + "...";
                }
                String string2 = object == null ? "unknown" : object.getClass().getName();
                throw new RuntimeException(String.format("Failed to set field '%s' using tuple value '%s' of type '%s' at index %d", fieldDescriptor.getName(), string, string2, i), exception);
            }
        }
        return builder.build();
    }

    public static Descriptors.Descriptor schemaToProtoDescriptor(ResourceSchema resourceSchema) throws Descriptors.DescriptorValidationException {
        return PigToProtobuf.schemaToProtoDescriptor(resourceSchema, null);
    }

    public static Descriptors.Descriptor schemaToProtoDescriptor(ResourceSchema resourceSchema, List<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>> list) throws Descriptors.DescriptorValidationException {
        ResourceSchema.ResourceFieldSchema resourceFieldSchema22;
        DescriptorProtos.DescriptorProto.Builder builder = DescriptorProtos.DescriptorProto.newBuilder();
        int n = 0;
        for (ResourceSchema.ResourceFieldSchema resourceFieldSchema22 : resourceSchema.getFields()) {
            int n2 = ++n;
            String string = resourceFieldSchema22.getName();
            byte by = resourceFieldSchema22.getType();
            DescriptorProtos.FieldDescriptorProto.Type type = PigToProtobuf.pigTypeToProtoType(by);
            LOG.info("Mapping Pig field " + string + " of type " + by + " to protobuf type: " + type);
            PigToProtobuf.addField(builder, string, n2, type);
        }
        if (n == 0) {
            throw new IllegalArgumentException("ResourceSchema does not have any fields");
        }
        if (list != null) {
            for (Pair pair : list) {
                PigToProtobuf.addField(builder, (String)pair.first, ++n, (DescriptorProtos.FieldDescriptorProto.Type)pair.second);
            }
        }
        builder.setName("PigToProtobufDynamicBuilder");
        DescriptorProtos.DescriptorProto descriptorProto = builder.build();
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor[] fileDescriptorArray = new Descriptors.FileDescriptor[]{};
        resourceFieldSchema22 = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])fileDescriptorArray);
        return resourceFieldSchema22.findMessageTypeByName("PigToProtobufDynamicBuilder");
    }

    private static List<Object> dataBagToRepeatedField(Message.Builder builder, Descriptors.FieldDescriptor fieldDescriptor, DataBag dataBag) {
        ArrayList<Object> arrayList = new ArrayList<Object>((int)dataBag.size());
        for (Tuple tuple : dataBag) {
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                Message.Builder builder2 = builder.newBuilderForField(fieldDescriptor);
                arrayList.add(PigToProtobuf.tupleToMessage(builder2, tuple));
                continue;
            }
            try {
                arrayList.add(PigToProtobuf.tupleFieldToSingleField(fieldDescriptor, tuple.get(0)));
            }
            catch (ExecException execException) {
                LOG.warn("Could not add a value for repeated field with descriptor " + fieldDescriptor);
            }
        }
        return arrayList;
    }

    private static Object tupleFieldToSingleField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        switch (fieldDescriptor.getType()) {
            case ENUM: {
                return fieldDescriptor.getEnumType().findValueByName((String)object);
            }
            case BOOL: {
                return (Integer)object != 0;
            }
            case BYTES: {
                return ByteString.copyFrom((byte[])((DataByteArray)object).get());
            }
        }
        return object;
    }

    private static void addField(DescriptorProtos.DescriptorProto.Builder builder, String string, int n, DescriptorProtos.FieldDescriptorProto.Type type) {
        DescriptorProtos.FieldDescriptorProto.Builder builder2 = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(string).setNumber(n).setType(type);
        builder.addField(builder2.build());
    }

    private static DescriptorProtos.FieldDescriptorProto.Type pigTypeToProtoType(byte by) {
        switch (by) {
            case 5: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
            }
            case 10: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 15: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
            }
            case 20: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT;
            }
            case 25: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
            }
            case 55: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            }
            case 50: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES;
            }
        }
        throw new IllegalArgumentException("Unsupported Pig type passed (" + by + ") where a simple type is expected while converting Pig to a dynamic Protobuf");
    }
}

