/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;

public class LongWritableConverter
extends AbstractWritableConverter<LongWritable> {
    public LongWritableConverter() {
        super(new LongWritable());
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema resourceFieldSchema = new ResourceSchema.ResourceFieldSchema();
        resourceFieldSchema.setType((byte)15);
        return resourceFieldSchema;
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return this.bytesToLong(dataByteArray.get());
    }

    @Override
    protected String toCharArray(LongWritable longWritable) throws IOException {
        return String.valueOf(longWritable.get());
    }

    @Override
    protected Integer toInteger(LongWritable longWritable) throws IOException {
        return (int)longWritable.get();
    }

    @Override
    protected Long toLong(LongWritable longWritable) throws IOException {
        return longWritable.get();
    }

    @Override
    protected Float toFloat(LongWritable longWritable) throws IOException {
        return Float.valueOf(longWritable.get());
    }

    @Override
    protected Double toDouble(LongWritable longWritable) throws IOException {
        return longWritable.get();
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        switch (resourceFieldSchema.getType()) {
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: {
                return;
            }
        }
        throw new IOException("Pig type '" + DataType.findTypeName((byte)resourceFieldSchema.getType()) + "' unsupported");
    }

    @Override
    protected LongWritable toWritable(String string) throws IOException {
        return this.toWritable(Long.parseLong(string));
    }

    @Override
    protected LongWritable toWritable(Integer n) throws IOException {
        return this.toWritable(n.longValue());
    }

    @Override
    protected LongWritable toWritable(Long l) throws IOException {
        ((LongWritable)this.writable).set(l.longValue());
        return (LongWritable)this.writable;
    }

    @Override
    protected LongWritable toWritable(Float f) throws IOException {
        return this.toWritable(f.longValue());
    }

    @Override
    protected LongWritable toWritable(Double d) throws IOException {
        return this.toWritable(d.longValue());
    }
}

