/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.mapreduce.output.LzoThriftB64LineOutputFormat;
import com.twitter.elephantbird.pig.store.LzoBaseStoreFunc;
import com.twitter.elephantbird.pig.util.PigToThrift;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;

public class LzoThriftB64LinePigStorage<T extends TBase<?, ?>>
extends LzoBaseStoreFunc {
    private TypeRef<T> typeRef;
    private ThriftWritable<T> writable;
    private PigToThrift<T> pigToThrift;

    public LzoThriftB64LinePigStorage(String string) {
        this.typeRef = PigUtil.getThriftTypeRef(string);
        this.writable = ThriftWritable.newInstance(this.typeRef.getRawClass());
        this.pigToThrift = PigToThrift.newInstance(this.typeRef);
    }

    public void putNext(Tuple tuple) throws IOException {
        if (tuple == null) {
            return;
        }
        try {
            this.writable.set(this.pigToThrift.getThriftObject(tuple));
            this.writer.write(null, this.writable);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    public OutputFormat<T, ThriftWritable<T>> getOutputFormat() throws IOException {
        return new LzoThriftB64LineOutputFormat<T>(this.typeRef);
    }
}

