/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.piggybank;

import com.twitter.elephantbird.mapreduce.io.ThriftConverter;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.thrift.TBase;

public class ThriftBytesToTuple<M extends TBase<?, ?>>
extends EvalFunc<Tuple> {
    private final TypeRef<M> typeRef;
    private final ThriftConverter<M> thriftConverter;
    private final ThriftToPig<M> thriftToPig;

    public ThriftBytesToTuple(String string) {
        this.typeRef = PigUtil.getThriftTypeRef(string);
        this.thriftConverter = ThriftConverter.newInstance(this.typeRef);
        this.thriftToPig = ThriftToPig.newInstance(this.typeRef);
    }

    public Tuple exec(Tuple tuple) throws IOException {
        if (tuple == null || tuple.size() < 1) {
            return null;
        }
        try {
            DataByteArray dataByteArray = (DataByteArray)tuple.get(0);
            M m = this.thriftConverter.fromBytes(dataByteArray.get());
            return m == null ? null : this.thriftToPig.getPigTuple(m);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Schema outputSchema(Schema schema) {
        return ThriftToPig.toSchema(this.typeRef.getRawClass());
    }
}

