/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.piggybank;

import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public abstract class BytesToThriftTuple<T extends TBase<?, ?>>
extends EvalFunc<Tuple> {
    private final TDeserializer deserializer_ = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
    private ThriftToPig<T> thriftToTuple_;
    private TypeRef<T> typeRef_;

    public void setTypeRef(TypeRef<T> typeRef) {
        this.typeRef_ = typeRef;
        this.thriftToTuple_ = ThriftToPig.newInstance(typeRef);
    }

    public Tuple exec(Tuple tuple) throws IOException {
        if (tuple == null || tuple.size() < 1) {
            return null;
        }
        try {
            TBase tBase = (TBase)this.typeRef_.safeNewInstance();
            DataByteArray dataByteArray = (DataByteArray)tuple.get(0);
            this.deserializer_.deserialize(tBase, dataByteArray.get());
            return this.thriftToTuple_.getPigTuple(tBase);
        }
        catch (IOException iOException) {
            this.log.warn((Object)("Caught exception " + iOException.getMessage()));
            return null;
        }
        catch (TException tException) {
            this.log.warn((Object)("Unable to deserialize Thrift object: " + (Object)((Object)tException)));
            return null;
        }
    }
}

