/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.mahout;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import com.twitter.elephantbird.pig.util.PigUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class VectorWritableConverter
extends AbstractWritableConverter<VectorWritable> {
    private static final String CARDINALITY_PARAM = "cardinality";
    private static final String DENSE_PARAM = "dense";
    private static final String SPARSE_PARAM = "sparse";
    private static final String SEQUENTIAL_PARAM = "sequential";
    private static final String FLOAT_PRECISION_PARAM = "floatPrecision";
    private final TupleFactory tupleFactory = TupleFactory.getInstance();
    private final BagFactory bagFactory = BagFactory.getInstance();
    private final boolean dense;
    private final boolean sparse;
    private final Integer cardinality;
    private final boolean sequential;
    private final boolean floatPrecision;

    public VectorWritableConverter() throws ParseException {
        this(new String[0]);
    }

    public VectorWritableConverter(String[] stringArray) throws ParseException {
        super(new VectorWritable());
        Preconditions.checkNotNull((Object)stringArray);
        CommandLine commandLine = this.parseArguments(stringArray);
        this.cardinality = commandLine.hasOption(CARDINALITY_PARAM) ? new Integer(commandLine.getOptionValue(CARDINALITY_PARAM)) : null;
        this.dense = commandLine.hasOption(DENSE_PARAM);
        this.sequential = commandLine.hasOption(SEQUENTIAL_PARAM);
        Preconditions.checkState((!this.dense || !this.sequential ? 1 : 0) != 0, (Object)"Options '-dense' and '-sequential' are mutually exclusive");
        this.sparse = commandLine.hasOption(SPARSE_PARAM) || this.sequential;
        Preconditions.checkState((!this.dense || !this.sparse ? 1 : 0) != 0, (Object)"Options '-dense' and '-sparse' are mutually exclusive");
        this.floatPrecision = commandLine.hasOption(FLOAT_PRECISION_PARAM);
        ((VectorWritable)this.writable).setWritesLaxPrecision(this.floatPrecision);
    }

    private CommandLine parseArguments(String[] stringArray) throws ParseException {
        return new GnuParser().parse(this.getOptions(), stringArray);
    }

    protected Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)CARDINALITY_PARAM);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.withDescription((String)"Expected cardinality of vector data.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)DENSE_PARAM);
        OptionBuilder.withDescription((String)"If specified along with cardinality, reported LOAD schema will be dense.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SPARSE_PARAM);
        OptionBuilder.withDescription((String)"If specified, reported LOAD schema will be sparse.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SEQUENTIAL_PARAM);
        OptionBuilder.withDescription((String)"If specified, Pig vector data will be converted to SequentialAccessSparseVector data on STORE. Otherwise, RandomAccessSparseVector is used.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)FLOAT_PRECISION_PARAM);
        OptionBuilder.withDescription((String)"If specified, float precision will be used when writing output data.");
        options.addOption(OptionBuilder.create());
        return options;
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        Byte by = this.floatPrecision ? (byte)20 : 25;
        if (this.sparse) {
            Schema.FieldSchema fieldSchema;
            if (PigUtil.Pig9orNewer) {
                Schema schema = new Schema();
                schema.add(new Schema.FieldSchema("index", 10));
                schema.add(new Schema.FieldSchema("value", by.byteValue()));
                Schema schema2 = new Schema();
                schema2.add(new Schema.FieldSchema("t", schema, 110));
                fieldSchema = new Schema.FieldSchema("entries", schema2, 120);
            } else {
                fieldSchema = new Schema.FieldSchema("entries", new Schema((List)ImmutableList.of((Object)new Schema.FieldSchema("index", 10), (Object)new Schema.FieldSchema("value", by.byteValue()))), 120);
            }
            if (this.cardinality != null) {
                return new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(null, new Schema((List)ImmutableList.of((Object)fieldSchema))));
            }
            return new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(null, new Schema((List)ImmutableList.of((Object)new Schema.FieldSchema(CARDINALITY_PARAM, 10), (Object)fieldSchema))));
        }
        if (this.dense && this.cardinality != null) {
            return new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(null, new Schema(Collections.nCopies(this.cardinality, new Schema.FieldSchema(null, by.byteValue())))));
        }
        return new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(null, 50));
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return this.bytesToTuple(dataByteArray.get(), null);
    }

    @Override
    protected Tuple toTuple(VectorWritable vectorWritable, ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        Preconditions.checkNotNull((Object)vectorWritable, (Object)"VectorWritable is null");
        Vector vector = vectorWritable.get();
        Preconditions.checkNotNull((Object)vector, (Object)"Vector is null");
        int n = vector.size();
        if (this.cardinality != null) {
            Preconditions.checkState((this.cardinality == n ? 1 : 0) != 0, (String)"Expecting cardinality %s but found cardinality %s", (Object[])new Object[]{this.cardinality, n});
        }
        Tuple tuple = null;
        if (vector.isDense()) {
            Preconditions.checkState((!this.sparse ? 1 : 0) != 0, (Object)"Expecting sparse vector but found dense vector");
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)vector.size());
            if (this.floatPrecision) {
                for (Vector.Element element : vector) {
                    arrayList.add(Float.valueOf((float)element.get()));
                }
            } else {
                for (Vector.Element element : vector) {
                    arrayList.add(element.get());
                }
            }
            tuple = this.tupleFactory.newTupleNoCopy((List)arrayList);
        } else {
            Preconditions.checkState((!this.dense ? 1 : 0) != 0, (Object)"Expecting dense vector but found sparse vector");
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)vector.getNumNondefaultElements());
            Iterator iterator = vector.iterateNonZero();
            while (iterator.hasNext()) {
                Vector.Element element = (Vector.Element)iterator.next();
                int n2 = element.index();
                Preconditions.checkState((this.cardinality == null || n2 < this.cardinality ? 1 : 0) != 0, (String)"Vector entry index %s is outside valid range [0, %s)", (Object[])new Object[]{n2, this.cardinality});
                double d = element.get();
                arrayList.add(this.tupleFactory.newTupleNoCopy((List)ImmutableList.of((Object)n2, (Object)d)));
            }
            tuple = this.cardinality != null ? this.tupleFactory.newTupleNoCopy((List)ImmutableList.of((Object)this.bagFactory.newDefaultBag((List)arrayList))) : this.tupleFactory.newTupleNoCopy((List)ImmutableList.of((Object)n, (Object)this.bagFactory.newDefaultBag((List)arrayList)));
        }
        return tuple;
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        VectorWritableConverter.assertFieldTypeEquals((byte)110, resourceFieldSchema.getType(), "tuple");
        ResourceSchema resourceSchema = resourceFieldSchema.getSchema();
        VectorWritableConverter.assertNotNull(resourceSchema, "ResourceSchema for tuple is null", new Object[0]);
        ResourceSchema.ResourceFieldSchema[] resourceFieldSchemaArray = resourceSchema.getFields();
        VectorWritableConverter.assertNotNull(resourceFieldSchemaArray, "Tuple field schemas are null", new Object[0]);
        if (resourceFieldSchemaArray.length == 1 && resourceFieldSchemaArray[0].getType() == 120) {
            Preconditions.checkNotNull((Object)this.cardinality, (Object)"Cardinality undefined");
            this.checkSparseVectorEntriesSchema(resourceFieldSchemaArray[0].getSchema());
        } else if (resourceFieldSchemaArray.length == 2 && resourceFieldSchemaArray[1].getType() == 120) {
            Preconditions.checkState((this.cardinality == null ? 1 : 0) != 0, (Object)"Cardinality already defined");
            VectorWritableConverter.assertFieldTypeEquals((byte)10, resourceFieldSchemaArray[0].getType(), "tuple[0]");
            this.checkSparseVectorEntriesSchema(resourceFieldSchemaArray[1].getSchema());
        } else {
            for (int i = 0; i < resourceFieldSchemaArray.length; ++i) {
                VectorWritableConverter.assertFieldTypeIsNumeric(resourceFieldSchemaArray[i].getType(), "tuple[" + i + "]");
            }
        }
    }

    private void checkSparseVectorEntriesSchema(ResourceSchema resourceSchema) throws IOException {
        VectorWritableConverter.assertNotNull(resourceSchema, "ResourceSchema of entries is null", new Object[0]);
        ResourceSchema.ResourceFieldSchema[] resourceFieldSchemaArray = resourceSchema.getFields();
        VectorWritableConverter.assertNotNull(resourceFieldSchemaArray, "Tuple field schemas are null", new Object[0]);
        VectorWritableConverter.assertTupleLength(1, resourceFieldSchemaArray.length, "entries");
        VectorWritableConverter.assertFieldTypeEquals((byte)110, resourceFieldSchemaArray[0].getType(), "entries[0]");
        ResourceSchema resourceSchema2 = resourceFieldSchemaArray[0].getSchema();
        VectorWritableConverter.assertNotNull(resourceSchema2, "ResourceSchema of entries[0] is null", new Object[0]);
        ResourceSchema.ResourceFieldSchema[] resourceFieldSchemaArray2 = resourceSchema2.getFields();
        VectorWritableConverter.assertNotNull(resourceFieldSchemaArray2, "Tuple field schemas are null", new Object[0]);
        VectorWritableConverter.assertTupleLength(2, resourceFieldSchemaArray2.length, "entries[0]");
        VectorWritableConverter.assertFieldTypeEquals((byte)10, resourceFieldSchemaArray2[0].getType(), "entries[0][0]");
        VectorWritableConverter.assertFieldTypeIsNumeric(resourceFieldSchemaArray2[1].getType(), "entries[0][1]");
    }

    @Override
    protected VectorWritable toWritable(Tuple tuple) throws IOException {
        Preconditions.checkNotNull((Object)tuple, (Object)"Tuple is null");
        DenseVector denseVector = null;
        if (VectorWritableConverter.isSparseVector(tuple)) {
            Preconditions.checkState((!this.dense ? 1 : 0) != 0, (Object)"Expecting dense vector but found sparse vector");
            int n = 0;
            DataBag dataBag = null;
            if (tuple.size() == 2) {
                n = (Integer)tuple.get(0);
                if (this.cardinality != null) {
                    Preconditions.checkState((this.cardinality == n ? 1 : 0) != 0, (String)"Expecting cardinality %s but found cardinality %s", (Object[])new Object[]{this.cardinality, n});
                }
                dataBag = (DataBag)tuple.get(1);
            } else {
                Preconditions.checkNotNull((Object)this.cardinality, (Object)"Cardinality is undefined");
                n = this.cardinality;
                dataBag = (DataBag)tuple.get(0);
            }
            denseVector = new RandomAccessSparseVector(n);
            for (Tuple tuple2 : dataBag) {
                VectorWritableConverter.validateSparseVectorEntry(tuple2);
                denseVector.setQuick(((Integer)tuple2.get(0)).intValue(), ((Number)tuple2.get(1)).doubleValue());
            }
            if (this.sequential) {
                denseVector = new SequentialAccessSparseVector((Vector)denseVector);
            }
        } else {
            Preconditions.checkState((!this.sparse ? 1 : 0) != 0, (Object)"Expecting sparse vector but found dense vector");
            VectorWritableConverter.validateDenseVector(tuple);
            double[] dArray = new double[tuple.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((Number)tuple.get(i)).doubleValue();
            }
            denseVector = new DenseVector(dArray, true);
        }
        ((VectorWritable)this.writable).set((Vector)denseVector);
        return (VectorWritable)this.writable;
    }

    private static boolean isSparseVector(Tuple tuple) throws IOException {
        VectorWritableConverter.assertNotNull(tuple, "Tuple is null", new Object[0]);
        return 1 == tuple.size() && 120 == tuple.getType(0) || 2 == tuple.size() && 10 == tuple.getType(0) && 120 == tuple.getType(1);
    }

    private static void validateSparseVectorEntry(Tuple tuple) throws IOException {
        VectorWritableConverter.assertNotNull(tuple, "Tuple is null", new Object[0]);
        VectorWritableConverter.assertTupleLength(2, tuple.size(), "tuple");
        VectorWritableConverter.assertFieldTypeEquals((byte)10, tuple.getType(0), "tuple[0]");
        VectorWritableConverter.assertFieldTypeIsNumeric(tuple.getType(1), "tuple[1]");
    }

    private static void validateDenseVector(Tuple tuple) throws IOException {
        VectorWritableConverter.assertNotNull(tuple, "Tuple is null", new Object[0]);
        for (int i = 0; i < tuple.size(); ++i) {
            VectorWritableConverter.assertFieldTypeIsNumeric(tuple.getType(i), "tuple[" + i + "]");
        }
    }

    private static void assertNotNull(Object object, String string, Object ... objectArray) throws IOException {
        if (object == null) {
            throw new IOException(String.format(string, objectArray));
        }
    }

    private static void assertFieldTypeEquals(byte by, byte by2, String string) throws IOException {
        if (by != by2) {
            throw new IOException(String.format("Expected %s of type '%s' but found type '%s'", string, DataType.findTypeName((byte)by), DataType.findTypeName((byte)by2)));
        }
    }

    private static void assertFieldTypeIsNumeric(byte by, String string) throws IOException {
        switch (by) {
            case 10: 
            case 15: 
            case 20: 
            case 25: {
                break;
            }
            default: {
                throw new IOException(String.format("Expected %s of numeric type but found type '%s'", string, DataType.findTypeName((byte)by)));
            }
        }
    }

    private static void assertTupleLength(int n, int n2, String string) throws IOException {
        if (n != n2) {
            throw new IOException(String.format("Expected %s of length %s but found length %s", string, n, n2));
        }
    }
}

