/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.pig.util.ProjectedThriftTupleFactory;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftPigLoader<M extends TBase<?, ?>>
extends LzoBaseLoadFunc {
    static final Logger LOG = LoggerFactory.getLogger(ThriftPigLoader.class);
    protected final TypeRef<M> typeRef;
    private ProjectedThriftTupleFactory<M> tupleTemplate;

    public ThriftPigLoader(String string) {
        this.typeRef = PigUtil.getThriftTypeRef(string);
    }

    public Tuple getNext() throws IOException {
        TBase tBase;
        if (this.tupleTemplate == null) {
            this.tupleTemplate = new ProjectedThriftTupleFactory<M>(this.typeRef, this.requiredFieldList);
        }
        return (tBase = (TBase)this.getNextBinaryValue(this.typeRef)) != null ? this.tupleTemplate.newTuple(tBase) : null;
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        return this.pushProjectionHelper(requiredFieldList);
    }

    @Override
    public ResourceSchema getSchema(String string, Job job) throws IOException {
        return new ResourceSchema(ThriftToPig.toSchema(this.typeRef.getRawClass()));
    }

    public InputFormat<LongWritable, BinaryWritable<M>> getInputFormat() throws IOException {
        return new MultiInputFormat<M>(this.typeRef);
    }
}

