/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.twitter.elephantbird.mapreduce.input.RawSequenceFileInputFormat;
import com.twitter.elephantbird.pig.store.SequenceFileStorage;
import com.twitter.elephantbird.pig.util.TextConverter;
import com.twitter.elephantbird.pig.util.WritableConverter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.UDFContext;

public class SequenceFileLoader<K extends Writable, V extends Writable>
extends FileInputLoadFunc
implements LoadPushDown,
LoadMetadata {
    public static final String CONVERTER_PARAM = "converter";
    private static final String READ_KEY_PARAM = "_readKey";
    private static final String READ_VALUE_PARAM = "_readValue";
    protected final CommandLine keyArguments;
    protected final CommandLine valueArguments;
    protected final WritableConverter<K> keyConverter;
    protected final WritableConverter<V> valueConverter;
    private final DataByteArray keyDataByteArray = new DataByteArray();
    private final DataByteArray valueDataByteArray = new DataByteArray();
    private final List<Object> tuple2 = Arrays.asList(new Object(), new Object());
    private final List<Object> tuple1 = Arrays.asList(new Object());
    private final List<Object> tuple0 = Collections.emptyList();
    private final TupleFactory tupleFactory = TupleFactory.getInstance();
    protected String signature;
    private RecordReader<DataInputBuffer, DataInputBuffer> reader;
    private boolean readKey = true;
    private boolean readValue = true;

    public SequenceFileLoader(String string, String string2) throws ParseException, IOException {
        Options options = this.getOptions();
        this.keyArguments = SequenceFileLoader.parseArguments(options, string);
        this.valueArguments = SequenceFileLoader.parseArguments(options, string2);
        this.keyConverter = SequenceFileLoader.getWritableConverter(this.keyArguments);
        this.valueConverter = SequenceFileLoader.getWritableConverter(this.valueArguments);
        this.initialize();
    }

    public SequenceFileLoader() throws ParseException, IOException {
        this("", "");
    }

    protected Options getOptions() {
        OptionBuilder.withLongOpt((String)CONVERTER_PARAM);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"cls");
        OptionBuilder.withDescription((String)("Converter type to use for conversion of data.  Defaults to '" + TextConverter.class.getName() + "'."));
        Option option = OptionBuilder.create((String)"c");
        return new Options().addOption(option);
    }

    private static CommandLine parseArguments(Options options, String string) throws ParseException {
        CommandLine commandLine = null;
        try {
            commandLine = new GnuParser().parse(options, string.split(" "));
        }
        catch (ParseException parseException) {
            new HelpFormatter().printHelp(SequenceFileStorage.class.getName() + "(keyArgs, valueArgs)", options);
            throw parseException;
        }
        return commandLine;
    }

    private static <T extends Writable> WritableConverter<T> getWritableConverter(CommandLine commandLine) {
        String[] stringArray = SequenceFileLoader.removeEmptyArgs(commandLine.getArgs());
        try {
            String string = commandLine.getOptionValue(CONVERTER_PARAM, TextConverter.class.getName());
            Class clazz = PigContext.resolveClassName((String)string);
            if (stringArray == null || stringArray.length == 0) {
                return (WritableConverter)clazz.newInstance();
            }
            try {
                Object[] objectArray = new Class[stringArray.length];
                Arrays.fill(objectArray, String.class);
                Constructor constructor = clazz.getConstructor((Class<?>[])objectArray);
                return (WritableConverter)constructor.newInstance(stringArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Constructor constructor = clazz.getConstructor(String[].class);
                    return (WritableConverter)constructor.newInstance(new Object[]{stringArray});
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Constructor constructor = clazz.getConstructor(String.class);
                    StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuilder.append(" ").append(stringArray[i]);
                    }
                    return (WritableConverter)constructor.newInstance(stringBuilder.toString());
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create WritableConverter instance", exception);
        }
    }

    private static String[] removeEmptyArgs(String[] stringArray) {
        ArrayList arrayList = Lists.newArrayList();
        for (String string : stringArray) {
            if (string == null || string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    protected void initialize() throws IOException {
        this.keyConverter.initialize(null);
        this.valueConverter.initialize(null);
    }

    public InputFormat<DataInputBuffer, DataInputBuffer> getInputFormat() throws IOException {
        return new RawSequenceFileInputFormat();
    }

    public LoadCaster getLoadCaster() throws IOException {
        return null;
    }

    public void setUDFContextSignature(String string) {
        this.signature = string;
    }

    protected Properties getContextProperties() {
        Preconditions.checkNotNull((Object)this.signature, (Object)"Signature is null");
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
    }

    protected void setContextProperty(String string, String string2) {
        Preconditions.checkNotNull((Object)string, (Object)"Context property name is null");
        this.getContextProperties().setProperty(this.signature + string, string2);
    }

    protected String getContextProperty(String string, String string2) {
        return this.getContextProperties().getProperty(this.signature + string, string2);
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return ImmutableList.of((Object)LoadPushDown.OperatorSet.PROJECTION);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        this.readValue = false;
        this.readKey = false;
        block4: for (LoadPushDown.RequiredField requiredField : requiredFieldList.getFields()) {
            int n = requiredField.getIndex();
            switch (n) {
                case 0: {
                    this.readKey = true;
                    continue block4;
                }
                case 1: {
                    this.readValue = true;
                    continue block4;
                }
            }
            throw new FrontendException("Expected field indices in [0, 1] but found index " + n);
        }
        this.setContextProperty(READ_KEY_PARAM, Boolean.toString(this.readKey));
        this.setContextProperty(READ_VALUE_PARAM, Boolean.toString(this.readValue));
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public ResourceSchema getSchema(String string, Job job) throws IOException {
        ResourceSchema.ResourceFieldSchema resourceFieldSchema = this.keyConverter.getLoadSchema();
        if (resourceFieldSchema == null) {
            return null;
        }
        resourceFieldSchema.setName("key");
        ResourceSchema.ResourceFieldSchema resourceFieldSchema2 = this.valueConverter.getLoadSchema();
        if (resourceFieldSchema2 == null) {
            return null;
        }
        resourceFieldSchema2.setName("value");
        ResourceSchema resourceSchema = new ResourceSchema();
        resourceSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{resourceFieldSchema, resourceFieldSchema2});
        return resourceSchema;
    }

    public ResourceStatistics getStatistics(String string, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String string, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression expression) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setLocation(String string, Job job) throws IOException {
        Preconditions.checkNotNull((Object)string, (Object)"Location is null");
        Preconditions.checkNotNull((Object)job, (Object)"Job is null");
        Path path = new Path(string);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{path});
        this.readKey = Boolean.parseBoolean(this.getContextProperty(READ_KEY_PARAM, "true"));
        this.readValue = Boolean.parseBoolean(this.getContextProperty(READ_VALUE_PARAM, "true"));
    }

    public void prepareToRead(RecordReader recordReader, PigSplit pigSplit) throws IOException {
        this.reader = recordReader;
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            List<Object> list = this.tuple0;
            if (this.readKey) {
                if (this.readValue) {
                    list = this.tuple2;
                    list.set(0, this.getCurrentKeyObject());
                    list.set(1, this.getCurrentValueObject());
                } else {
                    list = this.tuple1;
                    list.set(0, this.getCurrentKeyObject());
                }
            } else if (this.readValue) {
                list = this.tuple1;
                list.set(0, this.getCurrentValueObject());
            }
            return this.tupleFactory.newTupleNoCopy(list);
        }
        catch (InterruptedException interruptedException) {
            throw new ExecException("Error while reading input", 6018, 16, (Throwable)interruptedException);
        }
    }

    private Object getCurrentKeyObject() throws IOException, InterruptedException {
        DataInputBuffer dataInputBuffer = (DataInputBuffer)this.reader.getCurrentKey();
        this.keyDataByteArray.set(Arrays.copyOf(dataInputBuffer.getData(), dataInputBuffer.getLength()));
        return this.keyConverter.bytesToObject(this.keyDataByteArray);
    }

    private Object getCurrentValueObject() throws IOException, InterruptedException {
        DataInputBuffer dataInputBuffer = (DataInputBuffer)this.reader.getCurrentValue();
        this.valueDataByteArray.set(Arrays.copyOf(dataInputBuffer.getData(), dataInputBuffer.getLength()));
        return this.valueConverter.bytesToObject(this.valueDataByteArray);
    }
}

