/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.common.collect.Maps;
import com.twitter.elephantbird.mapreduce.input.LzoW3CLogInputFormat;
import com.twitter.elephantbird.mapreduce.input.LzoW3CLogRecordReader;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoW3CLogLoader
extends LzoBaseLoadFunc
implements LoadMetadata {
    protected static final Logger LOG = LoggerFactory.getLogger(LzoW3CLogLoader.class);
    protected static final TupleFactory tupleFactory_ = TupleFactory.getInstance();
    protected final String fileURI;

    public LzoW3CLogLoader(String string) throws IOException {
        LOG.debug("Initialize LzoW3CLogLoader from " + string);
        this.fileURI = string;
    }

    public Tuple getNext() throws IOException {
        LzoW3CLogRecordReader lzoW3CLogRecordReader = (LzoW3CLogRecordReader)this.reader_;
        if (lzoW3CLogRecordReader == null) {
            return null;
        }
        try {
            MapWritable mapWritable;
            if (lzoW3CLogRecordReader.nextKeyValue() && (mapWritable = lzoW3CLogRecordReader.getCurrentValue()) != null) {
                HashMap hashMap = Maps.newHashMap();
                for (Writable writable : mapWritable.keySet()) {
                    Writable writable2 = mapWritable.get((Object)writable);
                    hashMap.put(writable.toString(), writable2 != null ? writable2.toString() : null);
                }
                this.incrCounter(LzoW3CLogLoaderCounters.LinesW3CDecoded, 1L);
                this.incrCounter(LzoW3CLogLoaderCounters.UnparseableLines, lzoW3CLogRecordReader.getBadRecordsSkipped());
                return tupleFactory_.newTuple((Object)hashMap);
            }
        }
        catch (InterruptedException interruptedException) {
            int n = 6018;
            String string = "Error while reading input";
            throw new ExecException(string, n, 16, (Throwable)interruptedException);
        }
        return null;
    }

    @Override
    public void setLocation(String string, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)string);
    }

    public InputFormat getInputFormat() {
        return LzoW3CLogInputFormat.newInstance(this.fileURI);
    }

    @Override
    public String[] getPartitionKeys(String string, Job job) throws IOException {
        return null;
    }

    @Override
    public ResourceSchema getSchema(String string, Job job) throws IOException {
        return new ResourceSchema(new Schema(new Schema.FieldSchema("data", 100)));
    }

    @Override
    public ResourceStatistics getStatistics(String string, Job job) throws IOException {
        return null;
    }

    @Override
    public void setPartitionFilter(Expression expression) throws IOException {
    }

    protected static enum LzoW3CLogLoaderCounters {
        LinesW3CDecoded,
        UnparseableLines;

    }
}

