/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.common.collect.Maps;
import com.twitter.elephantbird.mapreduce.input.LzoJsonInputFormat;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoJsonLoader
extends LzoBaseLoadFunc {
    private static final Logger LOG = LoggerFactory.getLogger(LzoJsonLoader.class);
    private static final TupleFactory tupleFactory_ = TupleFactory.getInstance();

    public LzoJsonLoader() {
        LOG.debug("LzoJsonLoader creation");
    }

    public Tuple getNext() throws IOException {
        if (this.reader_ == null) {
            return null;
        }
        try {
            while (this.reader_.nextKeyValue()) {
                MapWritable mapWritable = (MapWritable)this.reader_.getCurrentValue();
                this.incrCounter(LzoJsonLoaderCounters.LinesRead, 1L);
                Tuple tuple = this.parseStringToTuple(mapWritable);
                if (tuple == null) continue;
                this.incrCounter(LzoJsonLoaderCounters.LinesJsonDecoded, 1L);
                return tuple;
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            int n = 6018;
            String string = "Error while reading input";
            throw new ExecException(string, n, 16, (Throwable)interruptedException);
        }
    }

    protected Tuple parseStringToTuple(MapWritable mapWritable) {
        try {
            HashMap hashMap = Maps.newHashMap();
            for (Writable writable : mapWritable.keySet()) {
                Writable writable2 = mapWritable.get((Object)writable);
                hashMap.put(writable.toString(), writable2 != null ? writable2.toString() : null);
            }
            return tupleFactory_.newTuple((Object)hashMap);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn("Very big number exceeds the scale of long: " + mapWritable.toString(), (Throwable)numberFormatException);
            this.incrCounter(LzoJsonLoaderCounters.LinesParseErrorBadNumber, 1L);
            return null;
        }
        catch (ClassCastException classCastException) {
            LOG.warn("Could not convert to Json Object: " + mapWritable.toString(), (Throwable)classCastException);
            this.incrCounter(LzoJsonLoaderCounters.LinesParseError, 1L);
            return null;
        }
    }

    @Override
    public void setLocation(String string, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)string);
    }

    public InputFormat getInputFormat() {
        return new LzoJsonInputFormat();
    }

    protected static enum LzoJsonLoaderCounters {
        LinesRead,
        LinesJsonDecoded,
        LinesParseError,
        LinesParseErrorBadNumber;

    }
}

