/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.common.collect.Maps;
import com.twitter.elephantbird.pig.load.LzoJsonLoader;
import com.twitter.elephantbird.pig.util.PigCounterHelper;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLoader
extends PigStorage {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLoader.class);
    protected RecordReader reader_;
    private static final TupleFactory tupleFactory_ = TupleFactory.getInstance();
    private final JSONParser jsonParser_ = new JSONParser();
    private final PigCounterHelper counterHelper_ = new PigCounterHelper();

    public Tuple getNext() throws IOException {
        if (this.reader_ == null) {
            return null;
        }
        try {
            while (this.reader_.nextKeyValue()) {
                Text text = (Text)this.reader_.getCurrentValue();
                this.incrCounter(LzoJsonLoader.LzoJsonLoaderCounters.LinesRead, 1L);
                Tuple tuple = this.parseStringToTuple(text.toString());
                if (tuple == null) continue;
                this.incrCounter(LzoJsonLoader.LzoJsonLoaderCounters.LinesJsonDecoded, 1L);
                return tuple;
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            int n = 6018;
            String string = "Error while reading input";
            throw new ExecException(string, n, 16, (Throwable)interruptedException);
        }
    }

    public void prepareToRead(RecordReader recordReader, PigSplit pigSplit) {
        this.reader_ = recordReader;
    }

    public InputFormat getInputFormat() {
        return new TextInputFormat();
    }

    protected void incrCounter(Enum<?> enum_, long l) {
        this.counterHelper_.incrCounter(enum_, l);
    }

    protected Tuple parseStringToTuple(String string) {
        try {
            HashMap hashMap = Maps.newHashMap();
            JSONObject jSONObject = (JSONObject)this.jsonParser_.parse(string);
            if (jSONObject != null) {
                for (Object e : jSONObject.keySet()) {
                    Object object = jSONObject.get(e);
                    hashMap.put(e.toString(), object != null ? object.toString() : null);
                }
            } else {
                LOG.warn("Could not json-decode string: " + string);
                this.incrCounter(JsonLoaderCounters.LinesParseError, 1L);
                return null;
            }
            return tupleFactory_.newTuple((Object)hashMap);
        }
        catch (ParseException parseException) {
            LOG.warn("Could not json-decode string: " + string, (Throwable)parseException);
            this.incrCounter(JsonLoaderCounters.LinesParseError, 1L);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn("Very big number exceeds the scale of long: " + string, (Throwable)numberFormatException);
            this.incrCounter(JsonLoaderCounters.LinesParseErrorBadNumber, 1L);
            return null;
        }
        catch (ClassCastException classCastException) {
            LOG.warn("Could not convert to Json Object: " + string, (Throwable)classCastException);
            this.incrCounter(JsonLoaderCounters.LinesParseError, 1L);
            return null;
        }
    }

    protected static enum JsonLoaderCounters {
        LinesRead,
        LinesJsonDecoded,
        LinesParseError,
        LinesParseErrorBadNumber;

    }
}

