/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.twitter.data.proto.BlockStorage;
import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.util.Protobufs;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BinaryBlockWriter<M> {
    protected static final int DEFAULT_NUM_RECORDS_PER_BLOCK = 100;
    private final OutputStream out_;
    private final int numRecordsPerBlock_;
    protected final Class<M> innerClass_;
    private final BinaryConverter<M> binaryConverter_;
    private int numRecordsWritten_ = 0;
    private BlockStorage.SerializedBlock.Builder builder_;

    protected BinaryBlockWriter(OutputStream outputStream, Class<M> clazz, BinaryConverter<M> binaryConverter, int n) {
        this.out_ = outputStream;
        this.numRecordsPerBlock_ = n;
        this.innerClass_ = clazz;
        this.binaryConverter_ = binaryConverter;
        this.builder_ = this.reinitializeBlockBuilder();
    }

    public void write(M m) throws IOException {
        if (m instanceof Message) {
            this.builder_.addProtoBlobs(((Message)m).toByteString());
        } else {
            this.builder_.addProtoBlobs(ByteString.copyFrom((byte[])this.binaryConverter_.toBytes(m)));
        }
        ++this.numRecordsWritten_;
        if (this.builder_.getProtoBlobsCount() == this.numRecordsPerBlock_) {
            this.serialize();
        }
    }

    public BlockStorage.SerializedBlock.Builder reinitializeBlockBuilder() {
        return BlockStorage.SerializedBlock.newBuilder().setVersion(1).setProtoClassName(this.innerClass_.getCanonicalName());
    }

    public void finish() throws IOException {
        if (this.builder_.getProtoBlobsCount() > 0) {
            this.serialize();
        }
    }

    public void close() throws IOException {
        this.finish();
        this.out_.close();
    }

    protected void serialize() throws IOException {
        BlockStorage.SerializedBlock serializedBlock = this.builder_.build();
        this.builder_ = this.reinitializeBlockBuilder();
        this.out_.write(Protobufs.KNOWN_GOOD_POSITION_MARKER);
        this.writeRawLittleEndian32(serializedBlock.getSerializedSize());
        serializedBlock.writeTo(this.out_);
    }

    private void writeRawLittleEndian32(int n) throws IOException {
        this.out_.write(n & 0xFF);
        this.out_.write(n >> 8 & 0xFF);
        this.out_.write(n >> 16 & 0xFF);
        this.out_.write(n >> 24 & 0xFF);
    }
}

