/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.input.LzoInputFormat;
import com.twitter.elephantbird.mapreduce.input.LzoProtobufB64LineRecordReader;
import com.twitter.elephantbird.mapreduce.input.LzoProtobufBlockRecordReader;
import com.twitter.elephantbird.mapreduce.input.LzoThriftB64LineRecordReader;
import com.twitter.elephantbird.mapreduce.input.LzoThriftBlockRecordReader;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.thrift.TBase;

public class MultiInputFormat<M>
extends LzoInputFormat<LongWritable, BinaryWritable<M>> {
    private static String CLASS_CONF_KEY = "elephantbird.class.for.MultiInputFormat";
    private TypeRef<M> typeRef;

    public MultiInputFormat() {
    }

    public MultiInputFormat(TypeRef<M> typeRef) {
        this.typeRef = typeRef;
    }

    public static void setInputFormatClass(Class<?> clazz, Job job) {
        job.setInputFormatClass(MultiInputFormat.class);
        MultiInputFormat.setClassConf(clazz, job.getConfiguration());
    }

    protected static void setClassConf(Class<?> clazz, Configuration configuration) {
        HadoopUtils.setInputFormatClass(configuration, CLASS_CONF_KEY, clazz);
    }

    public RecordReader<LongWritable, BinaryWritable<M>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        if (this.typeRef == null) {
            this.setTypeRef(configuration);
        }
        Class<M> clazz = this.typeRef.getRawClass();
        Format format = MultiInputFormat.determineFileFormat(inputSplit, configuration);
        if (Message.class.isAssignableFrom(clazz)) {
            switch (format) {
                case LZO_BLOCK: {
                    return new LzoProtobufBlockRecordReader<M>(this.typeRef);
                }
                case LZO_B64LINE: {
                    return new LzoProtobufB64LineRecordReader<M>(this.typeRef);
                }
            }
        }
        if (TBase.class.isAssignableFrom(clazz)) {
            switch (format) {
                case LZO_BLOCK: {
                    return new LzoThriftBlockRecordReader<M>(this.typeRef);
                }
                case LZO_B64LINE: {
                    return new LzoThriftB64LineRecordReader<M>(this.typeRef);
                }
            }
        }
        throw new IOException("could not determine reader for " + ((FileSplit)inputSplit).getPath() + " with class " + clazz.getName());
    }

    private void setTypeRef(Configuration configuration) {
        String string = configuration.get(CLASS_CONF_KEY);
        if (string == null) {
            throw new RuntimeException(CLASS_CONF_KEY + " is not set");
        }
        Class clazz = null;
        try {
            clazz = configuration.getClassByName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("failed to instantiate class '" + string + "'", classNotFoundException);
        }
        this.typeRef = new TypeRef<M>(clazz){};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Format determineFileFormat(InputSplit inputSplit, Configuration configuration) throws IOException {
        FileSplit fileSplit = (FileSplit)inputSplit;
        Path path = fileSplit.getPath();
        CompressionCodec compressionCodec = new CompressionCodecFactory(configuration).getCodec(path);
        if (compressionCodec == null) {
            throw new IOException("No codec for file " + path + " found");
        }
        FSDataInputStream fSDataInputStream = path.getFileSystem(configuration).open(path);
        CompressionInputStream compressionInputStream = null;
        try {
            compressionInputStream = compressionCodec.createInputStream((InputStream)fSDataInputStream);
            for (byte by : Protobufs.KNOWN_GOOD_POSITION_MARKER) {
                int n = compressionInputStream.read();
                if (n >= 0 && (byte)n == by) continue;
                Format format = Format.LZO_B64LINE;
                return format;
            }
        }
        finally {
            IOUtils.closeStream((Closeable)compressionInputStream);
            IOUtils.closeStream((Closeable)fSDataInputStream);
        }
        return Format.LZO_BLOCK;
    }

    private static enum Format {
        LZO_BLOCK,
        LZO_B64LINE;

    }
}

