/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import com.twitter.elephantbird.util.W3CLogParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.LineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoW3CLogRecordReader
extends LzoRecordReader<LongWritable, MapWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoW3CLogRecordReader.class);
    private LineReader in_;
    private final LongWritable key_ = new LongWritable();
    protected final Text currentLine_ = new Text();
    private final MapWritable value_ = new MapWritable();
    protected W3CLogParser w3cLogParser_ = null;
    private int badRecordsSkipped_ = 0;

    public synchronized void close() throws IOException {
        if (this.in_ != null) {
            this.in_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public MapWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream inputStream, Configuration configuration) throws IOException {
        this.in_ = new LineReader(inputStream, configuration);
        String string = this.getFieldDefinitionFile();
        FileSystem fileSystem = FileSystem.get((URI)URI.create(string), (Configuration)configuration);
        FSDataInputStream fSDataInputStream = fileSystem.open(new Path(string));
        this.w3cLogParser_ = new W3CLogParser((InputStream)fSDataInputStream);
        fSDataInputStream.close();
    }

    @Override
    protected void skipToNextSyncPoint(boolean bl) throws IOException {
        if (!bl) {
            this.in_.readLine(new Text());
        }
    }

    public long getBadRecordsSkipped() {
        return this.badRecordsSkipped_;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.value_.clear();
        this.badRecordsSkipped_ = 0;
        while (this.pos_ <= this.end_) {
            this.key_.set(this.pos_);
            int n = this.in_.readLine(this.currentLine_);
            if (n == 0) {
                return false;
            }
            this.pos_ = this.getLzoFilePos();
            if (!this.decodeLine()) {
                ++this.badRecordsSkipped_;
                continue;
            }
            return true;
        }
        return false;
    }

    protected boolean decodeLine() {
        return this.decodeLine(this.currentLine_.toString());
    }

    protected boolean decodeLine(String string) {
        try {
            Map<String, String> map = this.w3cLogParser_.parse(string);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string2 = entry.getValue();
                this.value_.put((Writable)new Text(entry.getKey()), (Writable)new Text(string2));
            }
            return true;
        }
        catch (IOException iOException) {
            LOG.debug("Could not w3c-decode string: " + string, (Throwable)iOException);
            return false;
        }
    }

    protected abstract String getFieldDefinitionFile();
}

