/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;

public class LzoLineRecordReader
extends LzoRecordReader<LongWritable, Text> {
    private LineReader in_;
    private final LongWritable key_ = new LongWritable();
    private final Text value_ = new Text();

    public synchronized void close() throws IOException {
        if (this.in_ != null) {
            this.in_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream inputStream, Configuration configuration) throws IOException {
        this.in_ = new LineReader(inputStream, configuration);
    }

    @Override
    protected void skipToNextSyncPoint(boolean bl) throws IOException {
        if (!bl) {
            this.in_.readLine(new Text());
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.pos_ <= this.end_) {
            this.key_.set(this.pos_);
            int n = this.in_.readLine(this.value_);
            if (n == 0) {
                return false;
            }
            this.pos_ = this.getLzoFilePos();
            return true;
        }
        return false;
    }
}

