/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import com.twitter.elephantbird.mapreduce.io.BinaryBlockReader;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoBinaryBlockRecordReader<M, W extends BinaryWritable<M>>
extends LzoRecordReader<LongWritable, W> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoBinaryBlockRecordReader.class);
    private final LongWritable key_ = new LongWritable();
    private final W value_;
    private final TypeRef<M> typeRef_;
    private final BinaryBlockReader<M> reader_;
    private Counter recordsReadCounter;
    private Counter recordErrorsCounter;

    public LzoBinaryBlockRecordReader(TypeRef<M> typeRef, BinaryBlockReader<M> binaryBlockReader, W w) {
        this.value_ = w;
        this.reader_ = binaryBlockReader;
        this.typeRef_ = typeRef;
    }

    public synchronized void close() throws IOException {
        if (this.reader_ != null) {
            this.reader_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public W getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream inputStream, Configuration configuration) throws IOException {
        this.reader_.setInputStream(inputStream);
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        String string = "LzoBlocks of " + this.typeRef_.getRawClass().getName();
        this.recordsReadCounter = HadoopUtils.getCounter((JobContext)taskAttemptContext, string, "Records Read");
        this.recordErrorsCounter = HadoopUtils.getCounter((JobContext)taskAttemptContext, string, "Errors");
        super.initialize(inputSplit, taskAttemptContext);
    }

    @Override
    protected void skipToNextSyncPoint(boolean bl) throws IOException {
        LOG.debug("LzoProtobufBlockRecordReader.skipToNextSyncPoint called with atFirstRecord = " + bl);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (true) {
            if (this.pos_ > this.end_) {
                this.reader_.markNoMoreNewBlocks();
            }
            ((BinaryWritable)this.value_).set(null);
            this.errorTracker.incRecords();
            Throwable throwable = null;
            try {
                if (!this.reader_.readNext((BinaryWritable<M>)this.value_)) {
                    return false;
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            this.key_.set(this.pos_);
            this.pos_ = this.getLzoFilePos();
            if (((BinaryWritable)this.value_).get() != null) {
                this.recordsReadCounter.increment(1L);
                return true;
            }
            this.errorTracker.incErrors(throwable);
            this.recordErrorsCounter.increment(1L);
        }
    }
}

