/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.output;

import com.twitter.elephantbird.mapreduce.io.ThriftConverter;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.util.Codecs;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.thrift.TBase;

public class DeprecatedLzoThriftB64LineRecordWriter<M extends TBase<?, ?>>
implements RecordWriter<NullWritable, ThriftWritable<M>> {
    private final ThriftConverter<M> converter_;
    private final DataOutputStream out_;
    private final Base64 base64_;

    public DeprecatedLzoThriftB64LineRecordWriter(ThriftConverter<M> thriftConverter, DataOutputStream dataOutputStream) {
        this.converter_ = thriftConverter;
        this.out_ = dataOutputStream;
        this.base64_ = Codecs.createStandardBase64();
    }

    public void write(NullWritable nullWritable, ThriftWritable<M> thriftWritable) throws IOException {
        byte[] byArray = this.base64_.encode(this.converter_.toBytes((TBase)thriftWritable.get()));
        this.out_.write(byArray);
        this.out_.write(10);
    }

    public void close(Reporter reporter) throws IOException {
        this.out_.close();
    }
}

