/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.input;

import com.twitter.elephantbird.mapred.input.DeprecatedLzoLineRecordReader;
import com.twitter.elephantbird.mapreduce.io.ThriftConverter;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.util.Codecs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.thrift.TBase;

public class DeprecatedLzoThriftB64LineRecordReader<M extends TBase<?, ?>>
implements RecordReader<LongWritable, ThriftWritable<M>> {
    private DeprecatedLzoLineRecordReader textReader;
    private TypeRef<M> typeRef_;
    private final ThriftWritable<M> value_;
    private final Base64 base64_ = Codecs.createStandardBase64();
    private final ThriftConverter<M> converter_;

    public DeprecatedLzoThriftB64LineRecordReader(Configuration configuration, FileSplit fileSplit, TypeRef<M> typeRef) throws IOException {
        this.textReader = new DeprecatedLzoLineRecordReader(configuration, fileSplit);
        this.typeRef_ = typeRef;
        this.converter_ = new ThriftConverter<M>(typeRef);
        this.value_ = new ThriftWritable<M>(typeRef);
    }

    public void close() throws IOException {
        this.textReader.close();
    }

    public LongWritable createKey() {
        return this.textReader.createKey();
    }

    public ThriftWritable<M> createValue() {
        return new ThriftWritable();
    }

    public long getPos() throws IOException {
        return this.textReader.getPos();
    }

    public float getProgress() throws IOException {
        return this.textReader.getProgress();
    }

    public boolean next(LongWritable longWritable, ThriftWritable<M> thriftWritable) throws IOException {
        Text text = new Text();
        while (this.textReader.next(longWritable, text)) {
            byte[] byArray;
            M m;
            if (text.equals((Object)"\n") || (m = this.converter_.fromBytes(this.base64_.decode(byArray = text.toString().getBytes("UTF-8")))) == null) continue;
            thriftWritable.set(m);
            return true;
        }
        return false;
    }
}

