/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.input;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ProtobufBlockReader;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecatedLzoProtobufBlockRecordReader<M extends Message, W extends ProtobufWritable<M>>
implements RecordReader<LongWritable, W> {
    private static final Logger LOG = LoggerFactory.getLogger(DeprecatedLzoProtobufBlockRecordReader.class);
    private final FSDataInputStream fileIn_;
    private CompressionCodecFactory codecFactory_ = null;
    private final long end_;
    private long start_;
    private long pos_;
    private W value_;
    protected ProtobufBlockReader<M> reader_;
    protected TypeRef<M> typeRef_;

    public DeprecatedLzoProtobufBlockRecordReader(TypeRef<M> typeRef, W w, Configuration configuration, FileSplit fileSplit) throws IOException {
        this.typeRef_ = typeRef;
        this.value_ = w;
        this.start_ = fileSplit.getStart();
        this.end_ = this.start_ + fileSplit.getLength();
        Path path = fileSplit.getPath();
        FileSystem fileSystem = path.getFileSystem(configuration);
        this.codecFactory_ = new CompressionCodecFactory(configuration);
        CompressionCodec compressionCodec = this.codecFactory_.getCodec(path);
        if (compressionCodec == null) {
            throw new IOException("No LZO codec found, cannot run.");
        }
        this.fileIn_ = fileSystem.open(fileSplit.getPath());
        this.createInputReader((InputStream)compressionCodec.createInputStream((InputStream)this.fileIn_), configuration);
        if (this.start_ != 0L) {
            LOG.debug("Seeking to split start at pos " + this.start_);
            this.fileIn_.seek(this.start_);
            this.skipToNextSyncPoint(true);
            this.start_ = this.fileIn_.getPos();
            LOG.debug("Start is now " + this.start_);
        } else {
            this.skipToNextSyncPoint(false);
        }
    }

    public boolean next(LongWritable longWritable, W w) throws IOException {
        if (this.pos_ > this.end_) {
            this.reader_.markNoMoreNewBlocks();
        }
        if (this.reader_.readProtobuf((ProtobufWritable<M>)w)) {
            longWritable.set(this.pos_);
            this.pos_ = this.fileIn_.getPos();
            return true;
        }
        return false;
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public W createValue() {
        return this.value_;
    }

    public float getProgress() throws IOException {
        if (this.start_ == this.end_) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos_ - this.start_) / (float)(this.end_ - this.start_));
    }

    public synchronized long getPos() throws IOException {
        return this.pos_;
    }

    public synchronized void close() throws IOException {
        if (this.reader_ != null) {
            this.reader_.close();
        }
    }

    protected void skipToNextSyncPoint(boolean bl) throws IOException {
        LOG.debug("DeprecatedLzoProtobufBlockRecordReader.skipToNextSyncPoint called with atFirstRecord = " + bl);
    }

    protected void createInputReader(InputStream inputStream, Configuration configuration) throws IOException {
        this.reader_ = new ProtobufBlockReader<M>(inputStream, this.typeRef_);
    }
}

