/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.LineReader;

public class DeprecatedLzoLineRecordReader
implements RecordReader<LongWritable, Text> {
    private CompressionCodecFactory codecFactory_ = null;
    private long start_;
    private long pos_;
    private final long end_;
    private final LineReader in_;
    private final FSDataInputStream fileIn_;

    DeprecatedLzoLineRecordReader(Configuration configuration, FileSplit fileSplit) throws IOException {
        this.start_ = fileSplit.getStart();
        this.end_ = this.start_ + fileSplit.getLength();
        Path path = fileSplit.getPath();
        FileSystem fileSystem = path.getFileSystem(configuration);
        this.codecFactory_ = new CompressionCodecFactory(configuration);
        CompressionCodec compressionCodec = this.codecFactory_.getCodec(path);
        if (compressionCodec == null) {
            throw new IOException("No LZO codec found, cannot run.");
        }
        this.fileIn_ = fileSystem.open(path);
        this.in_ = new LineReader((InputStream)compressionCodec.createInputStream((InputStream)this.fileIn_), configuration);
        if (this.start_ != 0L) {
            this.fileIn_.seek(this.start_);
            this.in_.readLine(new Text());
            this.start_ = this.fileIn_.getPos();
        }
        this.pos_ = this.start_;
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public Text createValue() {
        return new Text();
    }

    public boolean next(LongWritable longWritable, Text text) throws IOException {
        if (this.pos_ <= this.end_) {
            longWritable.set(this.pos_);
            int n = this.in_.readLine(text);
            if (n == 0) {
                return false;
            }
            this.pos_ = this.fileIn_.getPos();
            return true;
        }
        return false;
    }

    public float getProgress() throws IOException {
        if (this.start_ == this.end_) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos_ - this.start_) / (float)(this.end_ - this.start_));
    }

    public synchronized long getPos() throws IOException {
        return this.pos_;
    }

    public synchronized void close() throws IOException {
        if (this.in_ != null) {
            this.in_.close();
        }
    }
}

