/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.input;

import com.twitter.elephantbird.mapred.input.DeprecatedLzoLineRecordReader;
import com.twitter.elephantbird.mapreduce.input.LzoJsonRecordReader;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.json.simple.parser.JSONParser;

public class DeprecatedLzoJsonRecordReader
implements RecordReader<LongWritable, MapWritable> {
    private DeprecatedLzoLineRecordReader textReader;
    private JSONParser jsonParser = new JSONParser();
    private Text curLine = new Text();

    DeprecatedLzoJsonRecordReader(Configuration configuration, FileSplit fileSplit) throws IOException {
        this.textReader = new DeprecatedLzoLineRecordReader(configuration, fileSplit);
    }

    public void close() throws IOException {
        this.textReader.close();
    }

    public LongWritable createKey() {
        return this.textReader.createKey();
    }

    public MapWritable createValue() {
        return new MapWritable();
    }

    public long getPos() throws IOException {
        return this.textReader.getPos();
    }

    public float getProgress() throws IOException {
        return this.textReader.getProgress();
    }

    public boolean next(LongWritable longWritable, MapWritable mapWritable) throws IOException {
        while (this.textReader.next(longWritable, this.curLine)) {
            if (!LzoJsonRecordReader.decodeLineToJson(this.jsonParser, this.curLine, mapWritable)) continue;
            return true;
        }
        return false;
    }
}

