/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.input;

import com.hadoop.compression.lzo.LzoIndex;
import com.hadoop.compression.lzo.LzopCodec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

public abstract class DeprecatedLzoInputFormat<K, V>
extends FileInputFormat<K, V> {
    protected FileStatus[] listStatus(JobConf jobConf) throws IOException {
        ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>(Arrays.asList(super.listStatus(jobConf)));
        String string = new LzopCodec().getDefaultExtension();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FileStatus fileStatus = (FileStatus)iterator.next();
            Path path = fileStatus.getPath();
            if (path.toString().endsWith(string)) continue;
            iterator.remove();
        }
        return arrayList.toArray(new FileStatus[0]);
    }

    protected boolean isSplitable(FileSystem fileSystem, Path path) {
        try {
            return fileSystem.exists(path.suffix(".index"));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public InputSplit[] getSplits(JobConf jobConf, int n) throws IOException {
        FileSplit[] fileSplitArray = (FileSplit[])super.getSplits(jobConf, n);
        ArrayList<FileSplit> arrayList = new ArrayList<FileSplit>();
        Path path = null;
        LzoIndex lzoIndex = null;
        for (FileSplit fileSplit : fileSplitArray) {
            LzoIndex lzoIndex2;
            Path path2 = fileSplit.getPath();
            FileSystem fileSystem = path2.getFileSystem((Configuration)jobConf);
            if (path2.equals(path)) {
                lzoIndex2 = lzoIndex;
            } else {
                lzoIndex2 = LzoIndex.readIndex((FileSystem)fileSystem, (Path)path2);
                path = path2;
                lzoIndex = lzoIndex2;
            }
            if (lzoIndex2 == null) {
                throw new IOException("Index not found for " + path2);
            }
            if (lzoIndex2.isEmpty()) {
                arrayList.add(fileSplit);
                continue;
            }
            long l = fileSplit.getStart();
            long l2 = l + fileSplit.getLength();
            long l3 = lzoIndex2.alignSliceStartToIndex(l, l2);
            long l4 = lzoIndex2.alignSliceEndToIndex(l2, fileSystem.getFileStatus(path2).getLen());
            if (l3 == -1L || l4 == -1L) continue;
            arrayList.add(new FileSplit(path2, l3, l4 - l3, fileSplit.getLocations()));
        }
        return (InputSplit[])arrayList.toArray(new FileSplit[arrayList.size()]);
    }
}

