/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.cascading2.scheme;

import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import com.twitter.elephantbird.cascading2.scheme.LzoTextLine;
import com.twitter.elephantbird.util.Codecs;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoB64LineScheme
extends LzoTextLine {
    public static final String LINE_FIELD_NAME = "message";
    private static final String ENCODING = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(LzoB64LineScheme.class);
    private transient Base64 base64;

    public LzoB64LineScheme() {
        super(new Fields(new Comparable[]{LINE_FIELD_NAME}));
    }

    protected abstract Object decodeMessage(byte[] var1);

    protected abstract byte[] encodeMessage(Object var1);

    private Base64 getBase64() {
        if (this.base64 == null) {
            this.base64 = Codecs.createStandardBase64();
        }
        return this.base64;
    }

    public void sink(HadoopFlowProcess hadoopFlowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        OutputCollector outputCollector = (OutputCollector)sinkCall.getOutput();
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        Object object = tupleEntry.getTuple().getObject(0);
        byte[] byArray = this.encodeMessage(object);
        byte[] byArray2 = this.getBase64().encode(byArray);
        String string = new String(byArray2, ENCODING);
        outputCollector.collect(null, (Object)new Text(string));
    }

    public boolean source(HadoopFlowProcess hadoopFlowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object[] objectArray = (Object[])sourceCall.getContext();
        if (!((RecordReader)sourceCall.getInput()).next(objectArray[0], objectArray[1])) {
            return false;
        }
        boolean bl = false;
        Text text = (Text)objectArray[1];
        try {
            byte[] byArray = this.getBase64().decode(text.toString().getBytes(ENCODING));
            Object object = this.decodeMessage(byArray);
            if (object == null) {
                LOG.info("Couldn't decode " + text + " " + Arrays.toString(byArray));
            } else {
                sourceCall.getIncomingEntry().getTuple().set(0, object);
                bl = true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.info(unsupportedEncodingException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            LOG.info("Could not decode " + text);
        }
        return bl;
    }

    public void sourcePrepare(HadoopFlowProcess hadoopFlowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext((Object)new Object[2]);
        ((Object[])sourceCall.getContext())[0] = ((RecordReader)sourceCall.getInput()).createKey();
        ((Object[])sourceCall.getContext())[1] = ((RecordReader)sourceCall.getInput()).createValue();
    }
}

