/*
 * Decompiled with CFR 0.152.
 */
package cascalog.moreTaps;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

class WholeFileRecordReader
implements RecordReader<Text, BytesWritable> {
    private FileSplit fileSplit;
    private Configuration conf;
    private boolean processed = false;

    public WholeFileRecordReader(FileSplit fileSplit, Configuration configuration) throws IOException {
        this.fileSplit = fileSplit;
        this.conf = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next(Text text, BytesWritable bytesWritable) throws IOException {
        if (!this.processed) {
            byte[] byArray = new byte[(int)this.fileSplit.getLength()];
            Path path = this.fileSplit.getPath();
            String string = path.getName();
            text.set(string);
            FileSystem fileSystem = path.getFileSystem(this.conf);
            FSDataInputStream fSDataInputStream = null;
            try {
                fSDataInputStream = fileSystem.open(path);
                IOUtils.readFully((InputStream)fSDataInputStream, (byte[])byArray, (int)0, (int)byArray.length);
                bytesWritable.set(byArray, 0, byArray.length);
            }
            finally {
                IOUtils.closeStream((Closeable)fSDataInputStream);
            }
            this.processed = true;
            return true;
        }
        return false;
    }

    public Text createKey() {
        return new Text();
    }

    public BytesWritable createValue() {
        return new BytesWritable();
    }

    public long getPos() throws IOException {
        return this.processed ? this.fileSplit.getLength() : 0L;
    }

    public float getProgress() throws IOException {
        return this.processed ? 1.0f : 0.0f;
    }

    public void close() throws IOException {
    }
}

