/*
 * Decompiled with CFR 0.152.
 */
package cascalog.aggregator;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascalog.Util;
import cascalog.aggregator.CombinerSpec;
import cascalog.aggregator.FoldFunctor;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.RT;

public class ClojureMonoidFunctor
extends FoldFunctor<ISeq> {
    final CombinerSpec combinerSpec;
    transient IFn prepareFn;
    transient IFn combineFn;
    transient boolean isPrepared = false;

    public ClojureMonoidFunctor(Fields fields, CombinerSpec combinerSpec) {
        super(fields);
        this.combinerSpec = combinerSpec;
    }

    @Override
    public ISeq prepare(TupleEntry tupleEntry) {
        if (!this.isPrepared) {
            this.prepareFn = this.combinerSpec.getPrepareFn();
            this.combineFn = this.combinerSpec.getCombineFn();
            this.isPrepared = true;
        }
        return this.applyPrepareFn(tupleEntry);
    }

    public ISeq applyPrepareFn(TupleEntry tupleEntry) {
        ISeq iSeq = RT.seq(Util.tupleToList(tupleEntry));
        if (null != this.prepareFn) {
            return RT.seq((Object)Util.coerceToList(this.prepareFn.applyTo(iSeq)));
        }
        return iSeq;
    }

    @Override
    public ISeq fold(ISeq iSeq, TupleEntry tupleEntry) {
        return RT.seq((Object)Util.coerceToList(this.combineFn.applyTo(Util.cat(iSeq, this.applyPrepareFn(tupleEntry)))));
    }

    @Override
    public Tuple present(ISeq iSeq) {
        return Util.coerceToTuple(iSeq);
    }
}

