/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.joiner;

import cascading.pipe.joiner.Joiner;
import cascading.pipe.joiner.JoinerClosure;
import cascading.pipe.joiner.OuterJoin;
import cascading.tuple.Tuple;
import java.util.Iterator;
import java.util.List;

public class CascalogJoiner
implements Joiner {
    private final List<JoinType> joins;

    public CascalogJoiner(List<JoinType> list) {
        this.joins = list;
    }

    public Iterator<Tuple> getIterator(JoinerClosure joinerClosure) {
        return new JoinIterator(joinerClosure);
    }

    public int numJoins() {
        return this.joins.size() - 1;
    }

    protected class JoinIterator
    extends OuterJoin.JoinIterator {
        public JoinIterator(JoinerClosure joinerClosure) {
            super(joinerClosure);
        }

        protected boolean isOuter(int n) {
            return CascalogJoiner.this.joins.get(n) != JoinType.INNER && super.isOuter(n);
        }

        protected Iterator getIterator(int n) {
            if (CascalogJoiner.this.joins.get(n) == JoinType.EXISTS) {
                final boolean bl = this.closure.isEmpty(n);
                final Iterator iterator = super.getIterator(n);
                return new Iterator(){
                    private boolean emittedOne = false;

                    @Override
                    public boolean hasNext() {
                        return !this.emittedOne && iterator.hasNext();
                    }

                    public Object next() {
                        if (this.emittedOne) {
                            throw new RuntimeException("Shouldn't be accessing outerjoin_first more than once");
                        }
                        this.emittedOne = true;
                        Tuple tuple = (Tuple)iterator.next();
                        Tuple tuple2 = new Tuple();
                        for (int i = 0; i < tuple.size(); ++i) {
                            tuple2.add((Comparable)Boolean.valueOf(!bl));
                        }
                        return tuple2;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            return super.getIterator(n);
        }
    }

    public static enum JoinType {
        INNER,
        OUTER,
        EXISTS;

    }
}

