/*
 * Decompiled with CFR 0.152.
 */
package jcascalog.example;

import com.twitter.maple.tap.StdoutTap;
import jcascalog.Api;
import jcascalog.Option;
import jcascalog.Playground;
import jcascalog.Subquery;
import jcascalog.example.Split;
import jcascalog.op.Count;
import jcascalog.op.GT;
import jcascalog.op.LT;
import jcascalog.op.Multiply;

public class Examples {
    public static void twentyFiveYearOlds() {
        Api.execute(new StdoutTap(), new Subquery("?person").predicate((Object)Playground.AGE, "?person", 25));
    }

    public static void lessThanThirtyYearsOld() {
        Api.execute(new StdoutTap(), new Subquery("?person").predicate((Object)Playground.AGE, "?person", "?age").predicate((Object)new LT(), "?age", 30));
    }

    public static void lessThanThirtyYearsOldWithAge() {
        Api.execute(new StdoutTap(), new Subquery("?person", "?age").predicate((Object)Playground.AGE, "?person", "?age").predicate((Object)new LT(), "?age", 30));
    }

    public static void doubleAges() {
        Api.execute(new StdoutTap(), new Subquery("?person", "?double-age").predicate((Object)Playground.AGE, "?person", "?age").predicate((Object)new Multiply(), "?age", 2).out("?double-age"));
    }

    public static void distinctPeopleFromFollows() {
        Api.execute(new StdoutTap(), new Subquery("?person").predicate((Object)Playground.FOLLOWS, "?person", "_").predicate(Option.DISTINCT, true));
    }

    public static void nonDistinctPeopleFromFollows() {
        Api.execute(new StdoutTap(), new Subquery("?person").predicate((Object)Playground.FOLLOWS, "?person", "_"));
    }

    public static void malePeopleEmilyFollows() {
        Api.execute(new StdoutTap(), new Subquery("?person").predicate((Object)Playground.FOLLOWS, "emily", "?person").predicate((Object)Playground.GENDER, "?person", "m"));
    }

    public static void followsManyFollows() {
        Subquery subquery = new Subquery("?person").predicate((Object)Playground.FOLLOWS, "?person", "_").predicate((Object)new Count(), "?count").predicate((Object)new GT(), "?count", 2);
        Api.execute(new StdoutTap(), new Subquery("?person1", "?person2").predicate((Object)subquery, "?person1").predicate((Object)subquery, "?person2").predicate((Object)Playground.FOLLOWS, "?person1", "?person2"));
    }

    public static void followsManyFollowsConcise() {
        Subquery subquery = new Subquery("?person").predicate((Object)Playground.FOLLOWS, "?person", "_").predicate((Object)new Count(), "?count").predicate((Object)new GT(), "?count", 2);
        Api.execute(new StdoutTap(), new Subquery("?person1", "?person2").predicate(Api.each(subquery), "?person1", "?person2").predicate((Object)Playground.FOLLOWS, "?person1", "?person2"));
    }

    public static void sentenceUniqueWords() {
        Api.execute(new StdoutTap(), new Subquery("?word").predicate((Object)Playground.SENTENCE, "?sentence").predicate((Object)new Split(), "?sentence").out("?word").predicate(Option.DISTINCT, true));
    }

    public static void wordCount() {
        Api.execute(new StdoutTap(), new Subquery("?word", "?count").predicate((Object)Playground.SENTENCE, "?sentence").predicate((Object)new Split(), "?sentence").out("?word").predicate((Object)new Count(), "?count"));
    }

    public static void lineCountWithFiles() {
        Api.execute(Api.hfsTextline("/tmp/myresults"), new Subquery("?count").predicate(Api.hfsTextline("src/jvm/jcascalog/example"), "_").predicate((Object)new Count(), "?count"));
    }
}

