/*
 * Decompiled with CFR 0.152.
 */
package cascalog.kryo;

import carbonite.JavaBridge;
import com.esotericsoftware.kryo.Kryo;
import com.twitter.chill.KryoInstantiator;
import com.twitter.chill.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class ClojureKryoInstantiator
extends KryoInstantiator {
    Config config;

    public ClojureKryoInstantiator(Config config) {
        this.config = config;
    }

    public Kryo newKryo() {
        try {
            Kryo kryo = JavaBridge.defaultRegistry();
            kryo.register(ArrayList.class);
            kryo.register(HashMap.class);
            kryo.register(HashSet.class);
            kryo.setRegistrationRequired(this.config.getBoolean("cascalog.kryo.registrationrequired", false));
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            kryo.setReferences(this.config.getBoolean("cascalog.kryo.setreferences", false));
            kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
            return kryo;
        }
        catch (Exception exception) {
            throw new RuntimeException("unable to create new Kryo: " + exception);
        }
    }
}

