/*
 * Decompiled with CFR 0.152.
 */
package cascalog;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascalog.ParallelAgg;
import cascalog.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapred.JobConf;

public abstract class ClojureCombinerBase
extends BaseOperation
implements Function {
    private List<ParallelAgg> aggs;
    private Fields groupFields;
    private Fields sortFields;
    private List<Fields> argFields;
    private boolean includeSort;
    private String cacheConfArg;
    private int defaultCacheSize;
    private int cacheSize;
    LinkedHashMap<Tuple, Map<Integer, List<Object>>> combined;

    private static Fields appendFields(Fields fields, Fields ... fieldsArray) {
        for (Fields fields2 : fieldsArray) {
            if (fields2 == null) continue;
            fields = fields.append(fields2);
        }
        return fields;
    }

    public ClojureCombinerBase(Fields fields, boolean bl, Fields fields2, List<Fields> list, Fields fields3, List<ParallelAgg> list2, String string, int n) {
        super(ClojureCombinerBase.appendFields(fields, fields2, fields3));
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("All lists to ClojureCombiner must be same length");
        }
        this.aggs = new ArrayList<ParallelAgg>(list2);
        this.groupFields = fields;
        this.sortFields = fields2;
        this.includeSort = bl;
        this.argFields = new ArrayList<Fields>(list);
        this.cacheConfArg = string;
        this.defaultCacheSize = n;
    }

    public void prepare(FlowProcess flowProcess, OperationCall operationCall) {
        JobConf jobConf = ((HadoopFlowProcess)flowProcess).getJobConf();
        this.cacheSize = jobConf.getInt(this.cacheConfArg, this.defaultCacheSize);
        this.combined = new LinkedHashMap(1000, 0.75f, true);
        for (ParallelAgg parallelAgg : this.aggs) {
            parallelAgg.prepare(flowProcess);
        }
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        Object object;
        Map<Integer, List<Object>> map;
        Tuple tuple = functionCall.getArguments().selectTuple(this.groupFields);
        Tuple tuple2 = null;
        if (this.includeSort) {
            tuple2 = this.sortFields != null ? functionCall.getArguments().selectTuple(this.sortFields) : new Tuple();
        }
        if ((map = this.combined.get(tuple)) == null) {
            map = new HashMap<Integer, List<Object>>(this.aggs.size());
            this.combined.put(tuple, map);
        }
        for (int i = 0; i < this.aggs.size(); ++i) {
            try {
                Object object2;
                List<Object> list;
                object = this.argFields.get(i);
                ParallelAgg parallelAgg = this.aggs.get(i);
                if (object == null) {
                    list = parallelAgg.init(new ArrayList<Object>());
                } else {
                    object2 = functionCall.getArguments().selectTuple(object);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    if (tuple2 != null) {
                        arrayList.add(Util.tupleToList(tuple2));
                    }
                    Util.tupleIntoList(arrayList, object2);
                    list = parallelAgg.init(arrayList);
                }
                if (map.get(i) != null) {
                    object2 = map.get(i);
                    list = parallelAgg.combine((List<Object>)object2, list);
                }
                map.put(i, list);
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.combined.put(tuple, map);
        if (this.combined.size() >= this.cacheSize) {
            Tuple tuple3 = this.combined.keySet().iterator().next();
            object = (Map)this.combined.remove(tuple3);
            this.writeMap(tuple3, (Map<Integer, List<Object>>)object, (OperationCall)functionCall);
        }
    }

    private void writeMap(Tuple tuple, Map<Integer, List<Object>> map, OperationCall operationCall) {
        ArrayList<Object> arrayList = new ArrayList<Object>((Collection)map.get(0));
        for (int i = 1; i < this.aggs.size(); ++i) {
            arrayList.addAll((Collection<Object>)map.get(i));
        }
        this.write(tuple, arrayList, operationCall);
    }

    protected abstract void write(Tuple var1, List<Object> var2, OperationCall var3);

    public void cleanup(FlowProcess flowProcess, OperationCall operationCall) {
        for (Map.Entry<Tuple, Map<Integer, List<Object>>> entry : this.combined.entrySet()) {
            this.writeMap(entry.getKey(), entry.getValue(), operationCall);
        }
    }
}

