/*
 * Decompiled with CFR 0.152.
 */
package cascalog.aggregator;

import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascalog.Util;
import cascalog.aggregator.CombinerSpec;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.RT;

public class ClojureMonoidAggregator
extends BaseOperation<Tuple>
implements Aggregator<Tuple> {
    private final CombinerSpec combinerSpec;
    private transient IFn prepareFn;
    private transient IFn combineFn;
    private transient IFn presentFn;

    public ClojureMonoidAggregator(Fields fields, CombinerSpec combinerSpec) {
        super(fields);
        this.combinerSpec = combinerSpec;
    }

    public void prepare(FlowProcess flowProcess, OperationCall<Tuple> operationCall) {
        this.prepareFn = this.combinerSpec.getPrepareFn();
        this.combineFn = this.combinerSpec.getCombineFn();
        this.presentFn = this.combinerSpec.getPresentFn();
    }

    public void start(FlowProcess flowProcess, AggregatorCall<Tuple> aggregatorCall) {
        aggregatorCall.setContext(null);
    }

    public void aggregate(FlowProcess flowProcess, AggregatorCall<Tuple> aggregatorCall) {
        Tuple tuple;
        ISeq iSeq = RT.seq(Util.tupleToList(aggregatorCall.getArguments()));
        if (null != this.prepareFn) {
            iSeq = RT.seq((Object)Util.coerceToList(this.prepareFn.applyTo(iSeq)));
        }
        if (null == (tuple = (Tuple)aggregatorCall.getContext())) {
            Tuple tuple2 = Tuple.size((int)1);
            tuple2.set(0, (Object)iSeq);
            aggregatorCall.setContext((Object)tuple2);
        } else {
            ISeq iSeq2 = (ISeq)tuple.getObject(0);
            ISeq iSeq3 = RT.seq((Object)Util.coerceToList(this.combineFn.applyTo(Util.cat(iSeq2, iSeq))));
            tuple.set(0, (Object)iSeq3);
        }
    }

    public void complete(FlowProcess flowProcess, AggregatorCall<Tuple> aggregatorCall) {
        Tuple tuple = (Tuple)aggregatorCall.getContext();
        if (null == tuple) {
            throw new RuntimeException("ClojureMonoidAggregator completed with any aggregate calls");
        }
        ISeq iSeq = (ISeq)tuple.getObject(0);
        aggregatorCall.setContext(null);
        if (null != this.presentFn) {
            aggregatorCall.getOutputCollector().add(Util.coerceToTuple(this.presentFn.applyTo(iSeq)));
        } else {
            aggregatorCall.getOutputCollector().add(Util.coerceToTuple(iSeq));
        }
    }
}

