/*
 * Decompiled with CFR 0.152.
 */
package jcascalog;

import cascading.flow.Flow;
import cascalog.Util;
import clojure.lang.ArraySeq;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.IteratorSeq;
import clojure.lang.Keyword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jcascalog.Fields;

public class Api {
    public static Object hfsTextline(String string) {
        return Api.getApiFn("hfs-textline").invoke((Object)string);
    }

    public static Object hfsSeqfile(String string) {
        return Api.getApiFn("hfs-seqfile").invoke((Object)string);
    }

    public static Flow compileFlow(String string, List<Object> list, List<Object> list2) {
        List<Object> list3 = Api.toCompileFlowArgs(string, list, list2);
        return (Flow)Api.getApiFn("compile-flow").applyTo((ISeq)IteratorSeq.create(list3.iterator()));
    }

    public static Flow compileFlow(List<Object> list, List<Object> list2) {
        return Api.compileFlow(null, list, list2);
    }

    public static Flow compileFlow(String string, Object object, Object object2) {
        return Api.compileFlow(string, Arrays.asList(object), Arrays.asList(object2));
    }

    public static Flow compileFlow(Object object, Object object2) {
        return Api.compileFlow(Arrays.asList(object), Arrays.asList(object2));
    }

    public static void execute(String string, List<Object> list, List<Object> list2) {
        List<Object> list3 = Api.toCompileFlowArgs(string, list, list2);
        Api.getApiFn("?-").applyTo((ISeq)IteratorSeq.create(list3.iterator()));
    }

    public static void execute(String string, Object object, Object object2) {
        Api.execute(string, Arrays.asList(object), Arrays.asList(object2));
    }

    public static void execute(Object object, Object object2) {
        Api.execute(Arrays.asList(object), Arrays.asList(object2));
    }

    public static void execute(List<Object> list, List<Object> list2) {
        Api.execute(null, list, list2);
    }

    public static Object union(Object ... objectArray) {
        return Api.union(Util.toList(objectArray));
    }

    public static Object union(List<Object> list) {
        return Api.getApiFn("union").applyTo((ISeq)IteratorSeq.create(list.iterator()));
    }

    public static Object combine(Object ... objectArray) {
        return Api.combine(Util.toList(objectArray));
    }

    public static Object combine(List<Object> list) {
        return Api.getApiFn("combine").applyTo((ISeq)IteratorSeq.create(list.iterator()));
    }

    public static int numOutFields(Object object) {
        return ((Number)Api.getApiFn("num-out-fields").invoke(object)).intValue();
    }

    public static Fields getOutFields(Object object) {
        return new Fields((List)Api.getApiFn("get-out-fields").invoke(object));
    }

    public static Object selectFields(Object object, Fields fields) {
        return Api.getApiFn("select-fields").invoke(object, (Object)fields);
    }

    public static Object nameVars(Object object, Fields fields) {
        return Api.getApiFn("name-vars").invoke(object, (Object)fields);
    }

    public static String genNullableVar() {
        return (String)Util.bootSimpleFn("cascalog.logic.vars", "gen-nullable-var").invoke();
    }

    public static Fields genNullableVars(int n) {
        List list = (List)Util.bootSimpleFn("cascalog.logic.vars", "gen-nullable-vars").invoke((Object)n);
        return new Fields(new Object[]{list});
    }

    public static void setApplicationConf(Map map) {
        Util.bootSimpleFn("cascalog.cascading.conf", "set-job-conf!").invoke((Object)map);
    }

    public static Object negate(Object object) {
        return Api.getOpFn("negate").invoke(object);
    }

    public static Object all(Object ... objectArray) {
        return Api.getOpFn("all").applyTo((ISeq)ArraySeq.create((Object[])objectArray));
    }

    public static Object any(Object ... objectArray) {
        return Api.getOpFn("any").applyTo((ISeq)ArraySeq.create((Object[])objectArray));
    }

    public static Object comp(Object ... objectArray) {
        return Api.getOpFn("comp").applyTo((ISeq)ArraySeq.create((Object[])objectArray));
    }

    public static Object juxt(Object ... objectArray) {
        return Api.getOpFn("juxt").applyTo((ISeq)ArraySeq.create((Object[])objectArray));
    }

    public static Object each(Object object) {
        return Api.getOpFn("each").invoke(object);
    }

    public static Object partial(Object object, Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        for (Object object2 : objectArray) {
            arrayList.add(object2);
        }
        return Api.getOpFn("partial").applyTo((ISeq)IteratorSeq.create(arrayList.iterator()));
    }

    public static Object firstN(Object object, int n) {
        return Api.firstN(object, n, new FirstNArgs());
    }

    public static Object firstN(Object object, int n, FirstNArgs firstNArgs) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(n);
        arrayList.add(Keyword.intern((String)"sort"));
        arrayList.add(firstNArgs.sortParam);
        arrayList.add(Keyword.intern((String)"reverse"));
        arrayList.add(firstNArgs.reverse);
        return Api.getOpFn("first-n").applyTo((ISeq)IteratorSeq.create(arrayList.iterator()));
    }

    public static Object fixedSample(Object object, int n) {
        return Api.getOpFn("fixed-sample").invoke(object, (Object)n);
    }

    private static IFn getApiFn(String string) {
        return Util.bootSimpleFn("cascalog.api", string);
    }

    private static List<Object> toCompileFlowArgs(String string, List<Object> list, List<Object> list2) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("Must have same number of taps and generators");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string != null) {
            arrayList.add(string);
        }
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get(i));
            arrayList.add(list2.get(i));
        }
        return arrayList;
    }

    private static IFn getOpFn(String string) {
        return Util.bootSimpleFn("cascalog.logic.ops", string);
    }

    public static class FirstNArgs {
        private Object sortParam = null;
        private boolean reverse = false;

        public FirstNArgs sort(String string) {
            this.sortParam = string;
            return this;
        }

        public FirstNArgs sort(List<String> list) {
            this.sortParam = list;
            return this;
        }

        public FirstNArgs reverse(boolean bl) {
            this.reverse = bl;
            return this;
        }
    }
}

