/*
 * Decompiled with CFR 0.152.
 */
package cascalog;

import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.IteratorSeq;
import clojure.lang.MultiFn;
import clojure.lang.RT;
import clojure.lang.Var;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Util {
    static final Var require = RT.var((String)"clojure.core", (String)"require");
    static final Var symbol = RT.var((String)"clojure.core", (String)"symbol");

    public static ISeq cat(ISeq iSeq, ISeq iSeq2) {
        if (iSeq == null || RT.seq((Object)iSeq) == null) {
            return iSeq2;
        }
        return Util.cat(iSeq.next(), iSeq2).cons(iSeq.first());
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        Throwable throwable3 = throwable2.getCause();
        while (throwable3 != null) {
            throwable2 = throwable3;
            throwable3 = throwable2.getCause();
        }
        return throwable2;
    }

    public static synchronized void tryRequire(String string) {
        block2: {
            try {
                require.invoke(symbol.invoke((Object)string));
            }
            catch (Exception exception) {
                Throwable throwable = Util.getRootCause(exception);
                boolean bl = throwable instanceof FileNotFoundException;
                boolean bl2 = exception.getMessage().contains(string + ".clj on classpath");
                if (bl && bl2) break block2;
                throw new RuntimeException(exception);
            }
        }
    }

    public static synchronized Var getVar(String string, String string2) {
        Util.tryRequire(string);
        return RT.var((String)string, (String)string2);
    }

    public static synchronized IFn bootSimpleFn(String string, String string2) {
        return (IFn)Util.getVar(string, string2).deref();
    }

    public static synchronized MultiFn bootSimpleMultifn(String string, String string2) {
        return (MultiFn)Util.getVar(string, string2).deref();
    }

    public static synchronized IFn deserializeFn(byte[] byArray) {
        return (IFn)Util.bootSimpleFn("cascalog.logic.fn", "deserialize").invoke((Object)byArray);
    }

    public static synchronized byte[] serializeFn(IFn iFn) {
        return (byte[])Util.bootSimpleFn("cascalog.logic.fn", "serialize").invoke((Object)iFn);
    }

    public static ISeq coerceToSeq(Object object) {
        if (object instanceof List) {
            return RT.seq((Object)object);
        }
        return RT.list((Object)object);
    }

    public static List coerceToList(Object object) {
        if (object instanceof List) {
            return (List)object;
        }
        return Arrays.asList(object);
    }

    public static IteratorSeq coerceFromTuple(Tuple tuple) {
        return IteratorSeq.create((Iterator)tuple.iterator());
    }

    public static IteratorSeq coerceFromTuple(TupleEntry tupleEntry) {
        return Util.coerceFromTuple(tupleEntry.getTuple());
    }

    public static Tuple coerceToTuple(Object object) {
        if (object instanceof List) {
            Object[] objectArray = ((List)object).toArray();
            return new Tuple(objectArray);
        }
        return new Tuple(new Object[]{object});
    }

    public static List seqToList(ISeq iSeq) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (iSeq = RT.seq((Object)iSeq); iSeq != null; iSeq = iSeq.next()) {
            arrayList.add(iSeq.first());
        }
        return arrayList;
    }

    public static boolean truthy(Object object) {
        return object != null && !Boolean.FALSE.equals(object);
    }

    public static void tupleIntoList(List<Object> list, Tuple tuple) {
        for (Object e : tuple) {
            list.add(e);
        }
    }

    public static List<Object> tupleToList(Tuple tuple) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Util.tupleIntoList(arrayList, tuple);
        return arrayList;
    }

    public static List<Object> tupleToList(TupleEntry tupleEntry) {
        return Util.tupleToList(tupleEntry.getTuple());
    }

    public static List<Object> toList(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Collections.addAll(arrayList, objectArray);
        return arrayList;
    }
}

