package carbonite;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.LongSerializer;

import java.nio.ByteBuffer;
import java.sql.Date;

/** User: sritchie Date: 1/20/12 Time: 3:35 PM */
public class SqlDateSerializer extends Serializer {
    @Override public void writeObjectData(ByteBuffer byteBuffer, Object o) {
        Date date = (Date) o;
        LongSerializer.put(byteBuffer, date.getTime(), true);
    }

    @Override public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> tClass) {
        return (T) new Date(LongSerializer.get(byteBuffer, true));
    }
}
