/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.IndexTuple;
import cascading.tuple.Tuple;
import cascading.tuple.TuplePair;
import cascading.tuple.hadoop.TupleSerialization;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.io.WritableUtils;
import org.apache.log4j.Logger;

public class TupleInputStream
extends DataInputStream {
    private static final Logger LOG = Logger.getLogger(TupleInputStream.class);
    ElementReader elementReader;

    public TupleInputStream(InputStream inputStream, ElementReader elementReader) {
        super(inputStream);
        this.elementReader = elementReader;
    }

    public TupleInputStream(InputStream inputStream, boolean reuseInstances) {
        super(inputStream);
        this.elementReader = new TupleSerialization().getElementReader(reuseInstances);
    }

    public Tuple readTuple() throws IOException {
        return this.readTuple(new Tuple());
    }

    public Tuple readTuple(Tuple tuple) throws IOException {
        List<Object> elements = Tuple.elements(tuple);
        elements.clear();
        int len = WritableUtils.readVInt((DataInput)this);
        for (int i = 0; i < len; ++i) {
            elements.add(this.readType(WritableUtils.readVInt((DataInput)this)));
        }
        return tuple;
    }

    public TuplePair readTuplePair() throws IOException {
        return this.readTuplePair(new TuplePair());
    }

    public TuplePair readTuplePair(TuplePair tuplePair) throws IOException {
        Tuple[] tuples = TuplePair.tuples(tuplePair);
        this.readTuple(tuples[0]);
        this.readTuple(tuples[1]);
        return tuplePair;
    }

    public IndexTuple readIndexTuple() throws IOException {
        return this.readIndexTuple(new IndexTuple());
    }

    public IndexTuple readIndexTuple(IndexTuple indexTuple) throws IOException {
        indexTuple.setIndex(WritableUtils.readVInt((DataInput)this));
        indexTuple.setTuple(this.readTuple());
        return indexTuple;
    }

    private final Object readType(int type) throws IOException {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return WritableUtils.readString((DataInput)this);
            }
            case 2: {
                return Float.valueOf(this.readFloat());
            }
            case 3: {
                return this.readDouble();
            }
            case 4: {
                return WritableUtils.readVInt((DataInput)this);
            }
            case 5: {
                return WritableUtils.readVLong((DataInput)this);
            }
            case 6: {
                return this.readBoolean();
            }
            case 7: {
                return this.readShort();
            }
            case 8: {
                return this.readTuple();
            }
            case 9: {
                return this.readTuplePair();
            }
            case 10: {
                return this.readIndexTuple();
            }
        }
        return this.elementReader.read(type, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"closing tuple input stream");
        }
        try {
            super.close();
        }
        finally {
            if (this.elementReader != null) {
                this.elementReader.close();
            }
        }
    }

    public static interface ElementReader {
        public Object read(int var1, DataInputStream var2) throws IOException;

        public void close();
    }
}

