/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.tap.hadoop.ZipSplit;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class ZipInputFormat
extends FileInputFormat<LongWritable, Text>
implements JobConfigurable {
    public void configure(JobConf conf) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSplitable(FileSystem fs, Path file) {
        if (!this.isAllowSplits(fs)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("verifying ZIP format for file: " + file.toString()));
        }
        boolean splitable = true;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream((InputStream)fs.open(file));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry == null) {
                throw new IOException("no entries found, empty zip file");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ZIP format verification successful");
            }
            this.safeClose(zipInputStream);
        }
        catch (IOException exception) {
            try {
                LOG.error((Object)"exception encountered while trying to open and read ZIP input stream", (Throwable)exception);
                splitable = false;
                this.safeClose(zipInputStream);
            }
            catch (Throwable throwable) {
                this.safeClose(zipInputStream);
                throw throwable;
            }
        }
        return splitable;
    }

    protected Path[] listPathsInternal(JobConf jobConf) throws IOException {
        Path[] dirs = FileInputFormat.getInputPaths((JobConf)jobConf);
        if (dirs.length == 0) {
            throw new IOException("no input paths specified in job");
        }
        for (Path dir : dirs) {
            FileSystem fs = dir.getFileSystem((Configuration)jobConf);
            if (fs.isFile(dir)) continue;
            throw new IOException("does not support directories: " + dir);
        }
        return dirs;
    }

    protected FileStatus[] listStatus(JobConf jobConf) throws IOException {
        Path[] paths = this.listPathsInternal(jobConf);
        FileStatus[] statuses = new FileStatus[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            Path path = paths[i];
            statuses[i] = path.getFileSystem((Configuration)jobConf).getFileStatus(path);
        }
        return statuses;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"start splitting input ZIP files");
        }
        Path[] files = this.listPathsInternal(job);
        for (int i = 0; i < files.length; ++i) {
            Path file = files[i];
            FileSystem fs = file.getFileSystem((Configuration)job);
            if (fs.isFile(file) && fs.exists(file)) continue;
            throw new IOException("not a file: " + files[i]);
        }
        ArrayList<ZipSplit> splits = new ArrayList<ZipSplit>(numSplits);
        for (int i = 0; i < files.length; ++i) {
            Path file = files[i];
            FileSystem fs = file.getFileSystem((Configuration)job);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("opening zip file: " + file.toString()));
            }
            if (this.isAllowSplits(fs)) {
                this.makeSplits(job, splits, fs, file);
                continue;
            }
            this.makeSplit(job, splits, file);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"end splitting input ZIP files");
        }
        return (InputSplit[])splits.toArray(new ZipSplit[splits.size()]);
    }

    private void makeSplit(JobConf job, ArrayList<ZipSplit> splits, Path file) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating split for zip: " + file));
        }
        splits.add(new ZipSplit(file, -1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSplits(JobConf job, ArrayList<ZipSplit> splits, FileSystem fs, Path file) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream((InputStream)fs.open(file));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipSplit zipSplit = new ZipSplit(file, zipEntry.getName(), zipEntry.getSize());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("creating split for zip entry: %s size: %d method: %s compressed size: %d", zipEntry.getName(), zipEntry.getSize(), 8 == zipEntry.getMethod() ? "DEFLATED" : "STORED", zipEntry.getCompressedSize()));
                }
                splits.add(zipSplit);
            }
        }
        finally {
            this.safeClose(zipInputStream);
        }
    }

    public RecordReader<LongWritable, Text> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        ZipSplit split = (ZipSplit)genericSplit;
        Path file = split.getPath();
        long length = split.getLength();
        length = length == -1L ? 0x7FFFFFFFFFFFFFFEL : length;
        FileSystem fs = file.getFileSystem((Configuration)job);
        FSDataInputStream inputStream = fs.open(file);
        if (this.isAllowSplits(fs)) {
            return this.getReaderForEntry(inputStream, split, length);
        }
        return this.getReaderForAll(inputStream);
    }

    private RecordReader<LongWritable, Text> getReaderForAll(final FSDataInputStream inputStream) throws IOException {
        final long[] bytesSize = new long[]{0L};
        final long[] bytesRead = new long[]{0L};
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){
            boolean returnCurrent = false;
            ZipEntry nextEntry;
            ZipInputStream zipInputStream = new ZipInputStream((InputStream)inputStream);
            InputStream closeableInputStream = this.makeInputStream(this.zipInputStream);

            @Override
            public boolean hasMoreElements() {
                if (this.returnCurrent) {
                    return this.nextEntry != null;
                }
                this.getNext();
                return this.nextEntry != null;
            }

            @Override
            public InputStream nextElement() {
                if (this.returnCurrent) {
                    this.returnCurrent = false;
                    return this.closeableInputStream;
                }
                this.getNext();
                if (this.nextEntry == null) {
                    throw new IllegalStateException("no more zip entries in zip input stream");
                }
                return this.closeableInputStream;
            }

            private void getNext() {
                try {
                    this.nextEntry = this.zipInputStream.getNextEntry();
                    while (this.nextEntry != null && this.nextEntry.isDirectory()) {
                        this.nextEntry = this.zipInputStream.getNextEntry();
                    }
                    if (this.nextEntry != null) {
                        bytesSize[0] = bytesSize[0] + this.nextEntry.getSize();
                    }
                    this.returnCurrent = true;
                }
                catch (IOException exception) {
                    throw new RuntimeException("could not get next zip entry", exception);
                }
                finally {
                    if (this.nextEntry == null) {
                        ZipInputFormat.this.safeClose(this.zipInputStream);
                    }
                }
            }

            private InputStream makeInputStream(ZipInputStream zipInputStream) {
                return new FilterInputStream(zipInputStream){

                    @Override
                    public int read() throws IOException {
                        bytesRead[0] = bytesRead[0] + 1L;
                        return super.read();
                    }

                    @Override
                    public int read(byte[] bytes) throws IOException {
                        int result = super.read(bytes);
                        bytesRead[0] = bytesRead[0] + (long)result;
                        return result;
                    }

                    @Override
                    public int read(byte[] bytes, int i, int i1) throws IOException {
                        int result = super.read(bytes, i, i1);
                        bytesRead[0] = bytesRead[0] + (long)result;
                        return result;
                    }

                    @Override
                    public long skip(long l) throws IOException {
                        long result = super.skip(l);
                        bytesRead[0] = bytesRead[0] + result;
                        return result;
                    }

                    @Override
                    public void close() throws IOException {
                    }
                };
            }
        };
        return new LineRecordReader(new SequenceInputStream((Enumeration<? extends InputStream>)enumeration), 0L, Long.MAX_VALUE, Integer.MAX_VALUE){

            public float getProgress() {
                if (0L == bytesSize[0]) {
                    return 0.0f;
                }
                return Math.min(1.0f, (float)bytesRead[0] / (float)bytesSize[0]);
            }
        };
    }

    private RecordReader<LongWritable, Text> getReaderForEntry(FSDataInputStream inputStream, ZipSplit split, long length) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream((InputStream)inputStream);
        String entryPath = split.getEntryPath();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null && !zipEntry.getName().equals(entryPath)) {
            zipEntry = zipInputStream.getNextEntry();
        }
        return new LineRecordReader((InputStream)zipInputStream, 0L, length, Integer.MAX_VALUE);
    }

    protected boolean isAllowSplits(FileSystem fs) {
        URI uri = fs.getUri();
        String scheme = uri.getScheme();
        return scheme.equalsIgnoreCase("hdfs") || scheme.equalsIgnoreCase("file");
    }

    private void safeClose(ZipInputStream zipInputStream) {
        try {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
        catch (IOException exception) {
            LOG.error((Object)"exception while trying to close ZIP input stream", (Throwable)exception);
        }
    }
}

