/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.Hadoop18TapUtil;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class TapCollector
extends TupleEntryCollector
implements OutputCollector {
    private static final Logger LOG = Logger.getLogger(TapCollector.class);
    private JobConf conf;
    private RecordWriter writer;
    private String filenamePattern = "%s%spart-%05d";
    private String filename;
    private Tap tap;
    private String prefix;
    private TupleEntry outputEntry;
    private boolean isFileOutputFormat;
    private Reporter reporter = Reporter.NULL;

    public TapCollector(Tap tap, JobConf conf) throws IOException {
        this(tap, null, conf);
    }

    public TapCollector(Tap tap, String prefix, JobConf conf) throws IOException {
        this.tap = tap;
        this.prefix = prefix == null || prefix.length() == 0 ? null : prefix;
        this.conf = new JobConf((Configuration)conf);
        this.outputEntry = new TupleEntry(tap.getSinkFields());
        this.filenamePattern = conf.get("cascading.tapcollector.partname", this.filenamePattern);
        this.initalize();
    }

    private void initalize() throws IOException {
        this.tap.sinkInit(this.conf);
        OutputFormat outputFormat = this.conf.getOutputFormat();
        this.isFileOutputFormat = outputFormat instanceof FileOutputFormat;
        if (this.isFileOutputFormat) {
            Hadoop18TapUtil.setupJob(this.conf);
            this.filename = this.prefix != null ? String.format(this.filenamePattern, this.prefix, "/", this.conf.getInt("mapred.task.partition", 0)) : String.format(this.filenamePattern, "", "", this.conf.getInt("mapred.task.partition", 0));
            Hadoop18TapUtil.setupTask(this.conf);
        }
        this.writer = outputFormat.getRecordWriter(null, this.conf, this.filename, (Progressable)Reporter.NULL);
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    protected void collect(Tuple tuple) {
        try {
            this.outputEntry.setTuple(tuple);
            this.tap.sink(this.outputEntry, this);
        }
        catch (IOException exception) {
            throw new TapException("unable to write to: " + this.filename, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isFileOutputFormat) {
                LOG.info((Object)("closing tap collector for: " + new Path(this.tap.getPath(), this.filename)));
            } else {
                LOG.info((Object)("closing tap collector for: " + this.tap.toString()));
            }
            try {
                this.writer.close(this.reporter);
            }
            finally {
                if (this.isFileOutputFormat) {
                    if (Hadoop18TapUtil.needsTaskCommit(this.conf)) {
                        Hadoop18TapUtil.commitTask(this.conf);
                    }
                    Hadoop18TapUtil.cleanupJob(this.conf);
                }
            }
        }
        catch (IOException exception) {
            LOG.warn((Object)("exception closing: " + this.filename), (Throwable)exception);
            throw new TapException("exception closing: " + this.filename, exception);
        }
    }

    public void collect(Object writableComparable, Object writable) throws IOException {
        this.reporter.progress();
        this.writer.write(writableComparable, writable);
    }
}

