/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.log4j.Logger;

public class FSDigestInputStream
extends FSInputStream {
    private static final Logger LOG = Logger.getLogger(FSDigestInputStream.class);
    int count = 0;
    InputStream inputStream;
    String digestHex;

    public FSDigestInputStream(InputStream inputStream, String digestHex) throws IOException {
        this(inputStream, FSDigestInputStream.getMD5Digest(), digestHex);
    }

    public FSDigestInputStream(InputStream inputStream, MessageDigest messageDigest, String digestHex) {
        this.inputStream = digestHex == null ? inputStream : new DigestInputStream(inputStream, messageDigest);
        this.digestHex = digestHex;
    }

    private static MessageDigest getMD5Digest() throws IOException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new IOException("digest not found: " + exception.getMessage());
        }
    }

    public int read() throws IOException {
        ++this.count;
        return this.inputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.inputStream.read(b, off, len);
        this.count += result;
        return result;
    }

    public void close() throws IOException {
        this.inputStream.close();
        LOG.info((Object)("closing stream, testing digest: [" + (this.digestHex == null ? "none" : this.digestHex) + "]"));
        if (this.digestHex == null) {
            return;
        }
        String digestHex = new String(Hex.encodeHex((byte[])((DigestInputStream)this.inputStream).getMessageDigest().digest()));
        if (!digestHex.equals(this.digestHex)) {
            String message = "given digest: [" + this.digestHex + "], does not match input stream digest: [" + digestHex + "]";
            LOG.error((Object)message);
            throw new IOException(message);
        }
    }

    public void seek(long pos) throws IOException {
        if (this.getPos() == pos) {
            return;
        }
        if (this.getPos() > pos) {
            throw new IOException("cannot seek to " + pos + ", currently at" + this.getPos());
        }
        byte[] bytes = new byte[51200];
        for (int len = (int)(pos - this.getPos()); len > 0; len -= this.read(bytes, 0, Math.min(len, bytes.length))) {
        }
    }

    public long getPos() throws IOException {
        return this.count;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }
}

