/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.CascadingException;
import cascading.flow.Scope;
import cascading.scheme.Scheme;
import cascading.scheme.SequenceFile;
import cascading.tap.Hfs;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.lib.NullOutputFormat;

public class TempHfs
extends Hfs {
    final String name;
    private Class schemeClass;
    private String temporaryPath;

    public TempHfs(String name) {
        super(new SequenceFile(){});
        this.name = name;
    }

    public TempHfs(String name, boolean isNull) {
        super(isNull ? new NullScheme() : new SequenceFile(){});
        this.name = name;
    }

    public TempHfs(String name, Class schemeClass) {
        this.name = name;
        this.schemeClass = schemeClass == null ? SequenceFile.class : schemeClass;
    }

    public Class getSchemeClass() {
        return this.schemeClass;
    }

    private void makeTemporaryFile(JobConf conf) {
        if (this.stringPath != null) {
            return;
        }
        this.temporaryPath = this.makeTemporaryPathDir(this.name);
        this.stringPath = new Path(this.getTempPath(conf), this.temporaryPath).toString();
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incoming) {
        Scope scope = incoming.iterator().next();
        Fields outgoingFields = null;
        outgoingFields = scope.isGroup() ? scope.getOutValuesFields() : scope.getOutGroupingFields();
        try {
            this.setScheme((Scheme)this.schemeClass.getConstructor(Fields.class).newInstance(outgoingFields));
        }
        catch (Exception exception) {
            throw new CascadingException("unable to create specified scheme: " + this.schemeClass.getName());
        }
        return new Scope(outgoingFields);
    }

    @Override
    public void sourceInit(JobConf conf) throws IOException {
        this.makeTemporaryFile(conf);
        super.sourceInit(conf);
    }

    @Override
    public void sinkInit(JobConf conf) throws IOException {
        this.makeTemporaryFile(conf);
        super.sinkInit(conf);
    }

    @Override
    public boolean isWriteDirect() {
        return false;
    }

    @Override
    public boolean deletePath(JobConf conf) throws IOException {
        return super.deletePath(conf) && this.getFileSystem(conf).delete(new Path(this.getTempPath(conf), this.temporaryPath), true);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[" + this.name + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TempHfs tempHfs = (TempHfs)object;
        return !(this.name != null ? !this.name.equals(tempHfs.name) : tempHfs.name != null);
    }

    @Override
    public int hashCode() {
        return 31 * (System.identityHashCode(this) + this.name != null ? this.name.hashCode() : 0);
    }

    private static class NullScheme
    extends Scheme {
        private NullScheme() {
        }

        @Override
        public void sourceInit(Tap tap, JobConf conf) throws IOException {
        }

        @Override
        public void sinkInit(Tap tap, JobConf conf) throws IOException {
            conf.setOutputKeyClass(Tuple.class);
            conf.setOutputValueClass(Tuple.class);
            conf.setOutputFormat(NullOutputFormat.class);
        }

        @Override
        public Tuple source(Object key, Object value) {
            return null;
        }

        @Override
        public void sink(TupleEntry tupleEntry, OutputCollector outputCollector) throws IOException {
        }
    }
}

