/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.scheme.Scheme;
import cascading.tap.Hfs;
import cascading.tap.MultiSourceTap;
import cascading.tap.Tap;
import cascading.tap.TapException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;

public class GlobHfs
extends MultiSourceTap {
    private String pathPattern;
    private PathFilter pathFilter;

    @ConstructorProperties(value={"scheme", "pathPattern"})
    public GlobHfs(Scheme scheme, String pathPattern) {
        this(scheme, pathPattern, null);
    }

    @ConstructorProperties(value={"scheme", "pathPattern", "pathFilter"})
    public GlobHfs(Scheme scheme, String pathPattern, PathFilter pathFilter) {
        super(scheme);
        this.pathPattern = pathPattern;
        this.pathFilter = pathFilter;
    }

    @Override
    protected Tap[] getTaps() {
        if (this.taps != null) {
            return this.taps;
        }
        try {
            this.taps = this.makeTaps(new JobConf());
        }
        catch (IOException exception) {
            throw new TapException("unable to resolve taps for globbing path: " + this.pathPattern);
        }
        return this.taps;
    }

    private Tap[] makeTaps(JobConf conf) throws IOException {
        FileStatus[] statusList = null;
        Path path = new Path(this.pathPattern);
        FileSystem fileSystem = path.getFileSystem((Configuration)conf);
        statusList = this.pathFilter == null ? fileSystem.globStatus(path) : fileSystem.globStatus(path, this.pathFilter);
        if (statusList == null || statusList.length == 0) {
            throw new TapException("unable to find paths matching path pattern: " + this.pathPattern);
        }
        ArrayList<Hfs> notEmpty = new ArrayList<Hfs>();
        for (int i = 0; i < statusList.length; ++i) {
            if (statusList[i].getLen() == 0L) continue;
            notEmpty.add(new Hfs(this.getScheme(), statusList[i].getPath().toString()));
        }
        return notEmpty.toArray(new Tap[notEmpty.size()]);
    }

    @Override
    public void sourceInit(JobConf conf) throws IOException {
        this.taps = this.makeTaps(conf);
        super.sourceInit(conf);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        GlobHfs globHfs = (GlobHfs)object;
        if (this.pathFilter != null ? !this.pathFilter.equals(globHfs.pathFilter) : globHfs.pathFilter != null) {
            return false;
        }
        return !(this.pathPattern != null ? !this.pathPattern.equals(globHfs.pathPattern) : globHfs.pathPattern != null);
    }

    @Override
    public int hashCode() {
        int result = this.pathPattern != null ? this.pathPattern.hashCode() : 0;
        result = 31 * result + (this.pathFilter != null ? this.pathFilter.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "GlobHfs[" + this.pathPattern + ']';
    }
}

